/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class ItemWrench
extends Item {
    private static final Map<String, Mode> NAMED_MODES = Maps.newHashMap();

    public ItemWrench(Item.Properties properties) {
        super(properties);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.isSecondaryUseActive() && !world.isClientSide()) {
            this.incrementMode(itemStack);
            player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode", (Object[])new Object[]{Component.translatable((String)this.getMode(itemStack).getLabel())}), true);
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        return super.use(world, player, hand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        ItemStack itemStack = context.getItemInHand();
        if (context.getPlayer() != null && context.getPlayer().isSecondaryUseActive()) {
            switch (this.getMode(itemStack)) {
                case OFFSET: {
                    itemStack.getOrCreateTag().putLong("pos", context.getClickedPos().asLong());
                    context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.saved", (Object[])new Object[]{context.getClickedPos().toShortString()}), true);
                    return InteractionResult.SUCCESS;
                }
                case OFFSET_SIDE: {
                    itemStack.getOrCreateTag().putLong("pos", context.getClickedPos().asLong());
                    itemStack.getOrCreateTag().putLong("side", (long)context.getClickedFace().ordinal());
                    context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset_side.saved", (Object[])new Object[]{context.getClickedPos().toShortString(), context.getClickedFace().getSerializedName()}), true);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        if (context.getPlayer() != null && context.getPlayer().isSecondaryUseActive()) {
            return super.useOn(context);
        }
        ItemStack itemStack = context.getItemInHand();
        switch (this.getMode(itemStack)) {
            case DEFAULT: {
                blockState = context.getClickedFace().getAxis() == Direction.Axis.Y && blockState.hasProperty((Property)BlockStateProperties.FACING) ? (BlockState)blockState.setValue((Property)BlockStateProperties.FACING, (Comparable)(blockState.getValue((Property)BlockStateProperties.FACING) == Direction.UP ? Direction.DOWN : Direction.UP)) : (context.getClickedFace().getAxis() != Direction.Axis.Y && blockState.hasProperty((Property)BlockStateProperties.FACING) && ((Direction)blockState.getValue((Property)BlockStateProperties.FACING)).getAxis() == Direction.Axis.Y ? (BlockState)blockState.setValue((Property)BlockStateProperties.FACING, (Comparable)context.getClickedFace()) : blockState.rotate((LevelAccessor)context.getLevel(), context.getClickedPos(), Rotation.CLOCKWISE_90));
                context.getLevel().setBlockAndUpdate(context.getClickedPos(), blockState);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Mode getMode(ItemStack itemStack) {
        Mode mode;
        CompoundTag tag = itemStack.getTag();
        if (tag != null && (mode = NAMED_MODES.get(tag.getString("mode"))) != null) {
            return mode;
        }
        return Mode.DEFAULT;
    }

    public void setMode(ItemStack itemStack, Mode mode) {
        itemStack.getOrCreateTag().putString("mode", mode.getName());
    }

    public void incrementMode(ItemStack itemStack) {
        Mode mode = this.getMode(itemStack);
        int modeId = mode.ordinal();
        Mode nextMode = Mode.values()[(modeId + 1) % Mode.values().length];
        this.setMode(itemStack, nextMode);
        CompoundTag tag = itemStack.getTag();
        if (tag != null) {
            tag.remove("pos");
            tag.remove("side");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemStack, world, list, flag);
        CompoundTag tag = itemStack.getTag();
        Mode mode = this.getMode(itemStack);
        list.add((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode", (Object[])new Object[]{Component.translatable((String)mode.getLabel())}));
        if (tag != null) {
            if (tag.contains("pos")) {
                list.add((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.pos", (Object[])new Object[]{BlockPos.of((long)tag.getLong("pos")).toShortString()}).withStyle(ChatFormatting.GRAY));
            }
            if (tag.contains("side")) {
                list.add((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset_side.side", (Object[])new Object[]{Direction.values()[tag.getInt("side")].getSerializedName()}).withStyle(ChatFormatting.GRAY));
            }
        }
        list.add((Component)Component.translatable((String)(mode.getLabel() + ".info")).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    public <P extends IPartType<P, S>, S extends IPartState<P>> InteractionResult performPartAction(BlockHitResult hit, IPartType<P, S> partType, IPartState<P> partState, ItemStack itemStack, Player player, InteractionHand hand, PartPos center) {
        Mode mode = this.getMode(itemStack);
        CompoundTag tag = itemStack.getTag();
        switch (mode) {
            case OFFSET: {
                if (tag.contains("pos")) {
                    Vec3i offset = this.determineOffset(hit, tag);
                    if (partType.setTargetOffset(partState, center, offset)) {
                        player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.success"), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.fail"), true);
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.incomplete"), true);
                }
                return InteractionResult.SUCCESS;
            }
            case OFFSET_SIDE: {
                if (tag.contains("pos") && tag.contains("side")) {
                    Vec3i offset = this.determineOffset(hit, tag);
                    Direction side = Direction.values()[tag.getInt("side")];
                    if (partType.setTargetOffset(partState, center, offset)) {
                        partType.setTargetSideOverride(partState, side);
                        player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset_side.success"), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.fail"), true);
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.incomplete"), true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected Vec3i determineOffset(BlockHitResult hit, CompoundTag tag) {
        BlockPos source = hit.getBlockPos().relative(hit.getDirection());
        BlockPos targetAbs = BlockPos.of((long)tag.getLong("pos"));
        return new Vec3i(targetAbs.getX() - source.getX(), targetAbs.getY() - source.getY(), targetAbs.getZ() - source.getZ());
    }

    public static enum Mode {
        DEFAULT("integrateddynamics:default", "item.integrateddynamics.wrench.mode.default"),
        OFFSET("integrateddynamics:offset", "item.integrateddynamics.wrench.mode.offset"),
        OFFSET_SIDE("integrateddynamics:offset_side", "item.integrateddynamics.wrench.mode.offset_side");

        private final String name;
        private final String label;

        private Mode(String name, String label) {
            this.name = name;
            this.label = label;
            NAMED_MODES.put(name, this);
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

