/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMechanicalMachine;

public class LootFunctionCopyMechanicalMachineEnergy
extends LootItemConditionalFunction {
    public static final Codec<LootFunctionCopyMechanicalMachineEnergy> CODEC = RecordCodecBuilder.create(builder -> LootFunctionCopyMechanicalMachineEnergy.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootFunctionCopyMechanicalMachineEnergy::new));
    public static final LootItemFunctionType TYPE = new LootItemFunctionType(CODEC);

    protected LootFunctionCopyMechanicalMachineEnergy(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        BlockEntity tile = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof BlockEntityMechanicalMachine) {
            itemStack.getOrCreateTag().putInt("energy", ((BlockEntityMechanicalMachine)tile).getEnergy());
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return TYPE;
    }
}

