/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.cyclops.integrateddynamics.blockentity.BlockEntityMechanicalSqueezer;

public class LootFunctionCopyMechanicalSqueezerTank
extends LootItemConditionalFunction {
    public static final Codec<LootFunctionCopyMechanicalSqueezerTank> CODEC = RecordCodecBuilder.create(builder -> LootFunctionCopyMechanicalSqueezerTank.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootFunctionCopyMechanicalSqueezerTank::new));
    public static final LootItemFunctionType TYPE = new LootItemFunctionType(CODEC);

    protected LootFunctionCopyMechanicalSqueezerTank(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        BlockEntity tile = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof BlockEntityMechanicalSqueezer) {
            itemStack.getOrCreateTag().put("tank", (Tag)((BlockEntityMechanicalSqueezer)tile).getTank().writeToNBT(new CompoundTag()));
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return TYPE;
    }
}

