/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;

public class ActionLabelPacket
extends PacketCodec {
    public static final ResourceLocation ID = new ResourceLocation("integrateddynamics", "action_label");
    @CodecField
    private int variableId;
    @CodecField
    private String label;

    public ActionLabelPacket() {
        super(ID);
    }

    public ActionLabelPacket(int variableId, String label) {
        super(ID);
        this.variableId = variableId;
        this.label = label;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        if (this.label == null) {
            LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).removeUnsafe(this.variableId);
        } else {
            LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).putUnsafe(this.variableId, this.label);
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
        if (this.label == null) {
            LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).remove(this.variableId);
        } else {
            LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).put(this.variableId, this.label);
        }
    }
}

