/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeIngredientsLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeListLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;

public class LogicProgrammerSetElementInventory
extends PacketCodec {
    public static final ResourceLocation ID = new ResourceLocation("integrateddynamics", "logic_programmer_set_element");
    @CodecField
    private String listValueType;
    @CodecField
    private int baseX;
    @CodecField
    private int baseY;

    public LogicProgrammerSetElementInventory() {
        super(ID);
    }

    public LogicProgrammerSetElementInventory(IValueType listValueType, int baseX, int baseY) {
        super(ID);
        this.listValueType = listValueType.getUniqueName().toString();
        this.baseX = baseX;
        this.baseY = baseY;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(net.minecraft.world.level.Level world, Player player) {
    }

    public void actionServer(net.minecraft.world.level.Level world, ServerPlayer player) {
        ContainerLogicProgrammerBase container;
        ILogicProgrammerElement element;
        if (player.containerMenu instanceof ContainerLogicProgrammerBase && ((element = (container = (ContainerLogicProgrammerBase)player.containerMenu).getActiveElement()) instanceof ValueTypeListLPElement || element instanceof ValueTypeIngredientsLPElement)) {
            IValueType valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(this.listValueType));
            if (valueType != null) {
                ((ContainerLogicProgrammerBase)player.containerMenu).setElementInventory(valueType.createLogicProgrammerElement(), this.baseX, this.baseY);
            } else {
                IntegratedDynamics.clog(Level.WARN, "Got an invalid LogicProgrammerSetElementInventory packet: " + this.listValueType);
            }
        }
    }
}

