/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;

public class LogicProgrammerValueTypeRecipeValueChangedPacket
extends PacketCodec {
    public static final ResourceLocation ID = new ResourceLocation("integrateddynamics", "logic_programmer_value_type_recipe_value_changed");
    @CodecField
    private String value;
    @CodecField
    private int type;

    public LogicProgrammerValueTypeRecipeValueChangedPacket() {
        super(ID);
    }

    public LogicProgrammerValueTypeRecipeValueChangedPacket(String value, Type type) {
        super(ID);
        this.value = value;
        this.type = type.ordinal();
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ILogicProgrammerElement element;
        if (player.containerMenu instanceof ContainerLogicProgrammerBase && (element = ((ContainerLogicProgrammerBase)player.containerMenu).getActiveElement()) instanceof ValueTypeRecipeLPElement) {
            Type type = Type.values()[this.type];
            switch (type) {
                case INPUT_FLUID: {
                    ((ValueTypeRecipeLPElement)element).setInputFluidAmount(this.value);
                    break;
                }
                case INPUT_ENERGY: {
                    ((ValueTypeRecipeLPElement)element).setInputEnergy(this.value);
                    break;
                }
                case OUTPUT_FLUID: {
                    ((ValueTypeRecipeLPElement)element).setOutputFluidAmount(this.value);
                    break;
                }
                case OUTPUT_ENERGY: {
                    ((ValueTypeRecipeLPElement)element).setOutputEnergy(this.value);
                }
            }
            ((ContainerLogicProgrammerBase)player.containerMenu).onDirty();
        }
    }

    public static enum Type {
        INPUT_FLUID,
        INPUT_ENERGY,
        OUTPUT_FLUID,
        OUTPUT_ENERGY;

    }
}

