/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.client.render.level.PartOffsetsOverlayRenderer;
import org.cyclops.integrateddynamics.core.network.PartOffsetsClientNotifier;

public class PartOffsetsDataPacket
extends PacketCodec {
    public static final ResourceLocation ID = new ResourceLocation("integrateddynamics", "part_offsets_data");
    @CodecField
    private List<PartOffsetsClientNotifier.Entry> offsets;

    public PartOffsetsDataPacket() {
        super(ID);
    }

    public PartOffsetsDataPacket(List<PartOffsetsClientNotifier.Entry> offsets) {
        super(ID);
        this.offsets = offsets;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        PartOffsetsOverlayRenderer.getInstance().setData(this.offsets);
    }

    public void actionServer(Level world, ServerPlayer player) {
    }

    static {
        PacketCodec.addCodedAction(PartOffsetsClientNotifier.Entry.class, (PacketCodec.ICodecAction)new PacketCodec.ICodecAction(){

            public void encode(Object object, FriendlyByteBuf output) {
                PartOffsetsClientNotifier.Entry entry = (PartOffsetsClientNotifier.Entry)object;
                PacketCodec.getAction(BlockPos.class).encode((Object)entry.source(), output);
                PacketCodec.getAction(Direction.class).encode((Object)entry.sourceSide(), output);
                PacketCodec.getAction(Vec3i.class).encode((Object)entry.targetOffset(), output);
                PacketCodec.getAction(Direction.class).encode((Object)entry.targetSide(), output);
            }

            public Object decode(FriendlyByteBuf input) {
                return new PartOffsetsClientNotifier.Entry((BlockPos)PacketCodec.getAction(BlockPos.class).decode(input), (Direction)PacketCodec.getAction(Direction.class).decode(input), (Vec3i)PacketCodec.getAction(Vec3i.class).decode(input), (Direction)PacketCodec.getAction(Direction.class).decode(input));
            }
        });
    }
}

