/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.part.PartTypeConnector;

public class PartTypeConnectorMonoDirectional
extends PartTypeConnector<PartTypeConnectorMonoDirectional, State> {
    public PartTypeConnectorMonoDirectional(String name) {
        super(name, new PartRenderPosition(0.25f, 0.3125f, 0.5f, 0.5f));
    }

    @Override
    public int getConsumptionRate(State state) {
        return GeneralConfig.connectorMonoDirectionalBaseConsumption;
    }

    @Override
    public State constructDefaultState() {
        return new State();
    }

    @Override
    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        int offset;
        super.onNetworkAddition(network, partNetwork, target, state);
        if (!state.hasTarget() && (offset = this.findTargetOffset(target.getCenter())) > 0) {
            state.setTarget(offset);
            state.getTargetState(target.getCenter()).setTarget(offset);
            DimPos originPos = target.getCenter().getPos();
            DimPos targetPos = State.getTargetPos(target.getCenter(), state.getOffset());
            NetworkHelpers.initNetwork((ILevelExtension)originPos.getLevel(true), originPos.getBlockPos(), target.getCenter().getSide());
            NetworkHelpers.initNetwork((ILevelExtension)targetPos.getLevel(true), targetPos.getBlockPos(), target.getCenter().getSide().getOpposite());
        }
    }

    @Override
    public void onPostRemoved(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onPostRemoved(network, partNetwork, target, state);
        if (state.hasTarget()) {
            State targetState = state.getTargetState(target.getCenter());
            DimPos originPos = target.getCenter().getPos();
            DimPos targetPos = null;
            if (targetState != null) {
                targetState.removeTarget();
                targetPos = State.getTargetPos(target.getCenter(), state.getOffset());
            }
            state.removeTarget();
            NetworkHelpers.initNetwork((ILevelExtension)originPos.getLevel(true), originPos.getBlockPos(), target.getCenter().getSide());
            if (targetPos != null) {
                NetworkHelpers.initNetwork((ILevelExtension)targetPos.getLevel(true), targetPos.getBlockPos(), target.getCenter().getSide().getOpposite());
            }
        }
    }

    @Override
    public ItemStack getItemStack(State state, boolean saveState) {
        int offset = state.getOffset();
        state.setOffset(0);
        ItemStack itemStack = super.getItemStack(state, saveState);
        state.setOffset(offset);
        return itemStack;
    }

    protected int findTargetOffset(PartPos origin) {
        int offset = 0;
        State state = null;
        while (++offset < GeneralConfig.maxDirectionalConnectorOffset && (state = State.getUnboundTargetState(origin, offset)) == null) {
        }
        if (state != null) {
            return offset;
        }
        return 0;
    }

    protected IgnoredBlockStatus.Status getStatus(State state) {
        return state != null && state.hasTarget() ? IgnoredBlockStatus.Status.ACTIVE : IgnoredBlockStatus.Status.INACTIVE;
    }

    @Override
    public BlockState getBlockState(IPartContainer partContainer, Direction side) {
        IgnoredBlockStatus.Status status = this.getStatus(partContainer != null ? (State)partContainer.getPartState(side) : null);
        return (BlockState)((BlockState)super.getBlockState(partContainer, side).setValue((Property)IgnoredBlock.FACING, (Comparable)side)).setValue((Property)IgnoredBlockStatus.STATUS, (Comparable)((Object)status));
    }

    public static class State
    extends PartTypeConnector.State<PartTypeConnectorMonoDirectional> {
        private int offset = 0;

        @Override
        public Set<ISidedPathElement> getReachableElements() {
            if (this.getPartPos() != null) {
                Direction targetSide = this.getPartPos().getSide().getOpposite();
                IPathElement pathElement = BlockEntityHelpers.getCapability((DimPos)State.getTargetPos(this.getPartPos(), this.offset), (Object)targetSide, Capabilities.PathElement.BLOCK).orElse(null);
                if (pathElement != null) {
                    return Sets.newHashSet((Object[])new ISidedPathElement[]{SidedPathElement.of(pathElement, targetSide)});
                }
            }
            return Collections.emptySet();
        }

        public void setTarget(int offset) {
            this.setOffset(offset);
            this.sendUpdate();
            DimPos dimPos = this.getPosition();
            if (dimPos != null && this.offset > 0) {
                BlockPos pos = dimPos.getBlockPos();
                for (int i = 1; i < this.offset; ++i) {
                    pos = pos.relative(this.getPartPos().getSide());
                    ((ServerLevel)this.getPosition().getLevel(true)).sendParticles((ParticleOptions)DustParticleOptions.REDSTONE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        public boolean hasTarget() {
            return this.offset > 0;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public void removeTarget() {
            this.setTarget(0);
        }

        protected State getTargetState(PartPos origin) {
            return State.getTargetState(origin, this.offset);
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            super.writeToNBT(tag);
            if (this.offset > 0) {
                tag.putInt("connect_offset", this.offset);
            }
        }

        @Override
        public void readFromNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
            super.readFromNBT(valueDeseralizationContext, tag);
            if (tag.contains("connect_offset")) {
                this.offset = tag.getInt("connect_offset");
            }
        }

        protected static State getUnboundTargetState(PartPos origin, int offset) {
            State state = State.getTargetState(origin, offset);
            if (state != null && !state.hasTarget()) {
                return state;
            }
            return null;
        }

        protected static State getTargetState(PartPos origin, int offset) {
            PartPos targetPos = PartPos.of(State.getTargetPos(origin, offset), origin.getSide().getOpposite());
            PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(targetPos);
            if (partStateHolder != null && partStateHolder.getPart() instanceof PartTypeConnectorMonoDirectional) {
                return (State)partStateHolder.getState();
            }
            return null;
        }

        protected static DimPos getTargetPos(PartPos origin, int offset) {
            return DimPos.of((ResourceKey)origin.getPos().getLevelKey(), (BlockPos)origin.getPos().getBlockPos().relative(origin.getSide(), offset));
        }
    }
}

