/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;
import org.cyclops.integrateddynamics.item.ItemVariable;

public class ItemVariableCopyRecipe
extends CustomRecipe {
    private ValueDeseralizationContext lastValueDeseralizationContext;

    public ItemVariableCopyRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        this.lastValueDeseralizationContext = ValueDeseralizationContext.of(worldIn);
        return !this.assemble(inv, worldIn.registryAccess()).isEmpty();
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack withData = ItemStack.EMPTY;
        ItemStack withoutData = ItemStack.EMPTY;
        int count = 0;
        for (int j = 0; j < inv.getContainerSize(); ++j) {
            ItemStack element = inv.getItem(j);
            if (element.isEmpty() || !(element.getItem() instanceof ItemVariable)) continue;
            ++count;
            IVariableFacade facade = ((ItemVariable)((Object)RegistryEntries.ITEM_VARIABLE.get())).getVariableFacade(this.lastValueDeseralizationContext, element);
            if (!facade.isValid() && withoutData.isEmpty()) {
                withoutData = element;
            }
            if (!facade.isValid() || !withData.isEmpty() || element.getCount() != 1) continue;
            withData = element.copy();
        }
        if (count == 2 && !withoutData.isEmpty() && !withData.isEmpty()) {
            return withData;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return new ItemStack(RegistryEntries.ITEM_VARIABLE, 1);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList ret = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int j = 0; j < inv.getContainerSize(); ++j) {
            IVariableFacade facadeCopy;
            IVariableFacade facade;
            ItemStack element = inv.getItem(j);
            if (element.isEmpty() || !(element.getItem() instanceof ItemVariable) || !(facade = ((ItemVariable)((Object)RegistryEntries.ITEM_VARIABLE.get())).getVariableFacade(this.lastValueDeseralizationContext, element)).isValid()) continue;
            ItemStack copy = ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).copy(!MinecraftHelpers.isClientSideThread(), element);
            String label = LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getLabel(facade.getId());
            if (label != null && (facadeCopy = ((ItemVariable)((Object)RegistryEntries.ITEM_VARIABLE.get())).getVariableFacade(this.lastValueDeseralizationContext, copy)) != null) {
                LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).put(facadeCopy.getId(), label);
            }
            ret.set(j, (Object)copy);
        }
        return ret;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{this.getResultItem()}), Ingredient.of((ItemStack[])new ItemStack[]{this.getResultItem()})});
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_VARIABLE_COPY.get();
    }
}

