/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.world.gen.trunkplacer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockMenrilLogFilled;

public class TrunkPlacerMenril
extends TrunkPlacer {
    public static final Codec<TrunkPlacerMenril> CODEC = RecordCodecBuilder.create(builder -> TrunkPlacerMenril.trunkPlacerParts((RecordCodecBuilder.Instance)builder).and((App)Codec.intRange((int)0, (int)32).fieldOf("trunk_height_wider").forGetter(placer -> placer.heightWider)).apply((Applicative)builder, TrunkPlacerMenril::new));
    protected final int heightWider;

    public TrunkPlacerMenril(int baseHeight, int heightRandA, int heightRandB, int heightWider) {
        super(baseHeight, heightRandA, heightRandB);
        this.heightWider = heightWider;
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)RegistryEntries.TRUNK_PLACER_MENRIL.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> callback, RandomSource rand, int height, BlockPos pos, TreeConfiguration config) {
        int i;
        BlockPos basePos = pos.below();
        if (!(TreeFeature.isGrassOrDirt((LevelSimulatedReader)world, (BlockPos)basePos.north()) && TreeFeature.isGrassOrDirt((LevelSimulatedReader)world, (BlockPos)basePos.east()) && TreeFeature.isGrassOrDirt((LevelSimulatedReader)world, (BlockPos)basePos.south()) && TreeFeature.isGrassOrDirt((LevelSimulatedReader)world, (BlockPos)basePos.west()))) {
            return Collections.emptyList();
        }
        BlockPos posStump = pos.below();
        TrunkPlacerMenril.setDirtAt((LevelSimulatedReader)world, callback, (RandomSource)rand, (BlockPos)posStump, (TreeConfiguration)config);
        if (this.placeLog(world, callback, rand, pos.north(), config, Function.identity())) {
            TrunkPlacerMenril.setDirtAt((LevelSimulatedReader)world, callback, (RandomSource)rand, (BlockPos)posStump.north(), (TreeConfiguration)config);
        }
        if (this.placeLog(world, callback, rand, pos.east(), config, Function.identity())) {
            TrunkPlacerMenril.setDirtAt((LevelSimulatedReader)world, callback, (RandomSource)rand, (BlockPos)posStump.east(), (TreeConfiguration)config);
        }
        if (this.placeLog(world, callback, rand, pos.south(), config, Function.identity())) {
            TrunkPlacerMenril.setDirtAt((LevelSimulatedReader)world, callback, (RandomSource)rand, (BlockPos)posStump.south(), (TreeConfiguration)config);
        }
        if (this.placeLog(world, callback, rand, pos.west(), config, Function.identity())) {
            TrunkPlacerMenril.setDirtAt((LevelSimulatedReader)world, callback, (RandomSource)rand, (BlockPos)posStump.west(), (TreeConfiguration)config);
        }
        for (i = 0; i < height; ++i) {
            this.placeLog(world, callback, rand, pos.above(i), config, Function.identity());
        }
        for (i = height; i < height + this.heightWider; ++i) {
            BlockPos posIt = pos.above(i);
            this.placeLog(world, callback, rand, posIt, config, Function.identity());
            this.placeLog(world, callback, rand, posIt.north(), config, Function.identity());
            this.placeLog(world, callback, rand, posIt.east(), config, Function.identity());
            this.placeLog(world, callback, rand, posIt.south(), config, Function.identity());
            this.placeLog(world, callback, rand, posIt.west(), config, Function.identity());
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.above(height + this.heightWider), 0, false));
    }

    protected boolean placeLog(LevelSimulatedReader p_161887_, BiConsumer<BlockPos, BlockState> p_161888_, RandomSource p_161889_, BlockPos p_161890_, TreeConfiguration p_161891_, Function<BlockState, BlockState> p_161892_) {
        if (TreeFeature.validTreePos((LevelSimulatedReader)p_161887_, (BlockPos)p_161890_)) {
            BlockState logs = p_161892_.apply(p_161891_.trunkProvider.getState(p_161889_, p_161890_));
            logs = logs.getBlock() instanceof BlockMenrilLogFilled ? (BlockState)logs.setValue(BlockMenrilLogFilled.SIDE, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(p_161889_)) : logs;
            p_161888_.accept(p_161890_, logs);
            return true;
        }
        return false;
    }
}

