/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei;

import java.text.DecimalFormat;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammer;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerPortable;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenMechanicalDryingBasin;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenMechanicalSqueezer;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenOnTheDynamicsOfIntegration;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammer;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerPortable;
import org.cyclops.integrateddynamics.inventory.container.ContainerMechanicalDryingBasin;
import org.cyclops.integrateddynamics.inventory.container.ContainerMechanicalSqueezer;
import org.cyclops.integrateddynamicscompat.modcompat.jei.dryingbasin.DryingBasinRecipeCategory;
import org.cyclops.integrateddynamicscompat.modcompat.jei.dryingbasin.DryingBasinRecipeJEI;
import org.cyclops.integrateddynamicscompat.modcompat.jei.logicprogrammer.LogicProgrammerGhostIngredientHandler;
import org.cyclops.integrateddynamicscompat.modcompat.jei.logicprogrammer.LogicProgrammerTransferHandler;
import org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicaldryingbasin.MechanicalDryingBasinRecipeCategory;
import org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicaldryingbasin.MechanicalDryingBasinRecipeJEI;
import org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer.MechanicalSqueezerRecipeCategory;
import org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer.MechanicalSqueezerRecipeJEI;
import org.cyclops.integrateddynamicscompat.modcompat.jei.squeezer.SqueezerRecipeCategory;
import org.cyclops.integrateddynamicscompat.modcompat.jei.squeezer.SqueezerRecipeJEI;

@JeiPlugin
public class JEIIntegratedDynamicsConfig
implements IModPlugin {
    public static IJeiRuntime jeiRuntime;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new DryingBasinRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SqueezerRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new MechanicalDryingBasinRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new MechanicalSqueezerRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(DryingBasinRecipeCategory.TYPE, DryingBasinRecipeJEI.getAllRecipes());
        registry.addRecipes(SqueezerRecipeCategory.TYPE, SqueezerRecipeJEI.getAllRecipes());
        registry.addRecipes(MechanicalDryingBasinRecipeCategory.TYPE, MechanicalDryingBasinRecipeJEI.getAllRecipes());
        registry.addRecipes(MechanicalSqueezerRecipeCategory.TYPE, MechanicalSqueezerRecipeJEI.getAllRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_DRYING_BASIN.get()), new RecipeType[]{DryingBasinRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_SQUEEZER.get()), new RecipeType[]{SqueezerRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_MECHANICAL_DRYING_BASIN.get()), new RecipeType[]{MechanicalDryingBasinRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_MECHANICAL_SQUEEZER.get()), new RecipeType[]{MechanicalSqueezerRecipeCategory.TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerMechanicalDryingBasin.class, null, MechanicalDryingBasinRecipeCategory.TYPE, 0, 1, 5, 36);
        registry.addRecipeTransferHandler(ContainerMechanicalSqueezer.class, null, MechanicalSqueezerRecipeCategory.TYPE, 0, 1, 5, 36);
        registry.addUniversalRecipeTransferHandler(new LogicProgrammerTransferHandler<ContainerLogicProgrammer>(ContainerLogicProgrammer.class));
        registry.addUniversalRecipeTransferHandler(new LogicProgrammerTransferHandler<ContainerLogicProgrammerPortable>(ContainerLogicProgrammerPortable.class));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ContainerScreenMechanicalDryingBasin.class, 84, 31, 10, 27, new RecipeType[]{MechanicalDryingBasinRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenMechanicalSqueezer.class, 73, 36, 12, 18, new RecipeType[]{MechanicalSqueezerRecipeCategory.TYPE});
        registry.addGuiScreenHandler(ContainerScreenOnTheDynamicsOfIntegration.class, screen -> null);
        registry.addGhostIngredientHandler(ContainerScreenLogicProgrammer.class, new LogicProgrammerGhostIngredientHandler());
        registry.addGhostIngredientHandler(ContainerScreenLogicProgrammerPortable.class, new LogicProgrammerGhostIngredientHandler());
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("integrateddynamicscompat", "main");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIIntegratedDynamicsConfig.jeiRuntime = jeiRuntime;
    }

    public static MutableComponent getDurationSecondsTextComponent(int durationTicks) {
        String seconds = new DecimalFormat("#.##").format((double)durationTicks / 20.0);
        return Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{seconds});
    }

    public static MutableComponent getEnergyTextComponent(int durationTicks, int energyPerTick) {
        return Component.literal((String)String.format("%,d", durationTicks * energyPerTick)).append((Component)Component.translatable((String)"general.integrateddynamics.energy_unit"));
    }
}

