/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.util;

import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.ConfigScreenHandler;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import org.apache.commons.lang3.ArrayUtils;

public final class ModLoaderUtil {
    public static void registerKeybind(KeyMapping keyBinding) {
        Minecraft.getInstance().options.keyMappings = (KeyMapping[])ArrayUtils.add((Object[])Minecraft.getInstance().options.keyMappings, (Object)keyBinding);
    }

    public static void registerClientTickListener(final Runnable runnable) {
        NeoForge.EVENT_BUS.addListener((Consumer)new Consumer<TickEvent.ClientTickEvent>(){

            @Override
            public void accept(TickEvent.ClientTickEvent t) {
                runnable.run();
            }
        });
    }

    public static boolean isModLoaded(String name) {
        return ModList.get().isLoaded(name);
    }

    public static void disableDisplayTest() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> ModLoadingContext.get().getActiveContainer().getModInfo().getVersion().toString(), (remote, isServer) -> true));
    }

    public static void registerConfigScreen(Function<Screen, Screen> createScreen) {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> (Screen)createScreen.apply((Screen)screen)));
    }

    public static void registerClientSetupListener(final Runnable runnable) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener((Consumer)new Consumer<FMLClientSetupEvent>(){

            @Override
            public void accept(FMLClientSetupEvent t) {
                runnable.run();
            }
        });
    }

    public static <T extends Event> void registerForgeEvent(Consumer<T> handler) {
        NeoForge.EVENT_BUS.addListener(handler);
    }

    @Generated
    private ModLoaderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

