/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.client.BookModelLoader;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.config.ClientConfig;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.klikli_dev.modonomicon.datagen.DataGenerators;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.registry.CommandRegistry;
import com.klikli_dev.modonomicon.registry.CreativeModeTabRegistry;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.client.event.RegisterGuiOverlaysEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.overlay.VanillaGuiOverlay;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;

@Mod(value="modonomicon")
public class ModonomiconNeo {
    public ModonomiconNeo(IEventBus modEventBus) {
        Modonomicon.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.get().spec);
        CreativeModeTabRegistry.CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(Networking::register);
        modEventBus.addListener(CreativeModeTabRegistry::onCreativeModeTabBuildContents);
        NeoForge.EVENT_BUS.addListener(e -> {
            e.addListener((PreparableReloadListener)BookDataManager.get());
            e.addListener((PreparableReloadListener)MultiblockDataManager.get());
        });
        NeoForge.EVENT_BUS.addListener(e -> CommandRegistry.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        NeoForge.EVENT_BUS.addListener(e -> CommandRegistry.registerClientCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        NeoForge.EVENT_BUS.addListener(e -> {
            if (e.getPlayer() != null) {
                BookDataManager.get().onDatapackSync(e.getPlayer());
                MultiblockDataManager.get().onDatapackSync(e.getPlayer());
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> {
            Entity patt4368$temp = e.getEntity();
            if (patt4368$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt4368$temp;
                BookUnlockStateManager.get().updateAndSyncFor(player);
                BookVisualStateManager.get().syncFor(player);
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> {
            Level level;
            LevelAccessor patt4885$temp = e.getLevel();
            if (patt4885$temp instanceof Level && (level = (Level)patt4885$temp).dimension() == Level.OVERWORLD) {
                BookUnlockStateManager.get().saveData = null;
                BookVisualStateManager.get().saveData = null;
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> BookUnlockStateManager.get().onAdvancement((ServerPlayer)e.getEntity()));
        modEventBus.addListener(DataGenerators::gatherData);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(Client::onClientSetup);
            modEventBus.addListener(Client::onRegisterGeometryLoaders);
            modEventBus.addListener(Client::onRegisterGuiOverlays);
            NeoForge.EVENT_BUS.addListener(Client::onRecipesUpdated);
            modEventBus.addListener(e -> e.registerReloadListener((PreparableReloadListener)BookDataManager.Client.get()));
        }
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        LoaderRegistry.registerLoaders();
    }

    public static class Client {
        public static void onClientSetup(FMLClientSetupEvent event) {
            PageRendererRegistry.registerPageRenderers();
            NeoForge.EVENT_BUS.addListener(e -> {
                if (e.phase == TickEvent.Phase.END) {
                    ClientTicks.endClientTick(Minecraft.getInstance());
                }
            });
            NeoForge.EVENT_BUS.addListener(e -> {
                if (e.phase == TickEvent.Phase.START) {
                    ClientTicks.renderTickStart(e.renderTickTime);
                } else {
                    ClientTicks.renderTickEnd();
                }
            });
            NeoForge.EVENT_BUS.addListener(e -> {
                InteractionResult result = MultiblockPreviewRenderer.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
                if (result.consumesAction()) {
                    e.setCanceled(true);
                    e.setCancellationResult(result);
                }
            });
            NeoForge.EVENT_BUS.addListener(e -> {
                if (e.phase == TickEvent.Phase.END) {
                    MultiblockPreviewRenderer.onClientTick(Minecraft.getInstance());
                }
            });
            NeoForge.EVENT_BUS.addListener(e -> {
                if (e.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                    MultiblockPreviewRenderer.onRenderLevelLastEvent(e.getPoseStack());
                }
            });
        }

        public static void onRecipesUpdated(RecipesUpdatedEvent event) {
            BookDataManager.get().onRecipesUpdated((Level)Minecraft.getInstance().level);
        }

        public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
            event.register(Modonomicon.loc("book_model_loader"), (IGeometryLoader)new BookModelLoader());
        }

        public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerBelow(VanillaGuiOverlay.BOSS_EVENT_PROGRESS.id(), Modonomicon.loc("multiblock_hud"), (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> MultiblockPreviewRenderer.onRenderHUD(guiGraphics, partialTick));
        }
    }
}

