/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class BookEntryParent {
    protected ResourceLocation entryId;
    protected boolean drawArrow = true;
    protected boolean lineEnabled = true;
    protected boolean lineReversed = false;

    public BookEntryParent(ResourceLocation entry) {
        this.entryId = entry;
    }

    public static BookEntryParent fromJson(JsonObject json) {
        ResourceLocation entry = new ResourceLocation(GsonHelper.getAsString((JsonObject)json, (String)"entry"));
        BookEntryParent parent = new BookEntryParent(entry);
        parent.drawArrow = GsonHelper.getAsBoolean((JsonObject)json, (String)"draw_arrow", (boolean)parent.drawArrow);
        parent.lineEnabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"line_enabled", (boolean)parent.lineEnabled);
        parent.lineReversed = GsonHelper.getAsBoolean((JsonObject)json, (String)"line_reversed", (boolean)parent.lineReversed);
        return parent;
    }

    public static BookEntryParent fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation entry = buffer.readResourceLocation();
        BookEntryParent parent = new BookEntryParent(entry);
        parent.drawArrow = buffer.readBoolean();
        parent.lineEnabled = buffer.readBoolean();
        parent.lineReversed = buffer.readBoolean();
        return parent;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.entryId);
        buffer.writeBoolean(this.drawArrow);
        buffer.writeBoolean(this.lineEnabled);
        buffer.writeBoolean(this.lineReversed);
    }

    public BookEntry getEntry() {
        throw new UnsupportedOperationException("BookEntryParent is not resolved yet.");
    }

    public ResourceLocation getEntryId() {
        return this.entryId;
    }

    public boolean drawArrow() {
        return this.drawArrow;
    }

    public boolean isLineEnabled() {
        return this.lineEnabled;
    }

    public boolean isLineReversed() {
        return this.lineReversed;
    }
}

