/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BookIcon {
    private final ItemStack itemStack;
    private final ResourceLocation texture;
    private final int width;
    private final int height;

    public BookIcon(ItemStack stack) {
        this.itemStack = stack;
        this.texture = null;
        this.width = 16;
        this.height = 16;
    }

    public BookIcon(ResourceLocation texture, int width, int height) {
        this.texture = texture;
        this.itemStack = ItemStack.EMPTY;
        this.width = width;
        this.height = height;
    }

    public static BookIcon fromJson(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return BookIcon.fromString(new ResourceLocation(jsonElement.getAsString()));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("item")) {
            Item item = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(GsonHelper.getAsString((JsonObject)jsonObject, (String)"item")));
            return new BookIcon(new ItemStack((ItemLike)item));
        }
        if (jsonObject.has("texture")) {
            int width = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"width", (int)16);
            int height = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"height", (int)16);
            ResourceLocation texture = new ResourceLocation(GsonHelper.getAsString((JsonObject)jsonObject, (String)"texture"));
            return new BookIcon(texture, width, height);
        }
        throw new JsonParseException("BookIcon must have either item or texture defined." + jsonElement);
    }

    private static BookIcon fromString(ResourceLocation value) {
        if (value.getPath().endsWith(".png")) {
            return new BookIcon(value, 16, 16);
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(value);
        return new BookIcon(new ItemStack((ItemLike)item));
    }

    public static BookIcon fromNetwork(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            ResourceLocation texture = buffer.readResourceLocation();
            int width = buffer.readVarInt();
            int height = buffer.readVarInt();
            return new BookIcon(texture, width, height);
        }
        ResourceLocation rl = buffer.readResourceLocation();
        Item item = (Item)BuiltInRegistries.ITEM.get(rl);
        return new BookIcon(new ItemStack((ItemLike)item));
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        if (this.texture != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(this.texture, x, y, 16, 16, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        } else {
            guiGraphics.renderItem(this.itemStack, x, y);
        }
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.texture != null);
        if (this.texture != null) {
            buffer.writeResourceLocation(this.texture);
            buffer.writeVarInt(this.width);
            buffer.writeVarInt(this.height);
        } else {
            buffer.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)this.itemStack.getItem()));
        }
    }
}

