/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class PatchouliLink {
    public static final String PROTOCOL_PATCHOULI = "patchouli://";
    public ResourceLocation bookId;
    public ResourceLocation entryId;
    public int pageNumber;

    private PatchouliLink() {
    }

    private static PatchouliLink fromEntry(String linkText) {
        linkText = linkText.substring(PROTOCOL_PATCHOULI.length());
        PatchouliLink bookLink = new PatchouliLink();
        String[] bookAndEntry = linkText.split("//", 2);
        bookLink.bookId = ResourceLocation.tryParse((String)bookAndEntry[0]);
        if (bookAndEntry.length == 1) {
            throw new IllegalArgumentException("Invalid patchouli link, does not contain any entry id: " + linkText);
        }
        String entryId = bookAndEntry[1];
        int lastHashIndex = entryId.lastIndexOf("#");
        if (lastHashIndex >= 0) {
            String postHash = entryId.substring(lastHashIndex);
            String path = StringUtils.removeEnd((String)entryId.substring(0, lastHashIndex), (String)"/");
            bookLink.entryId = path.contains(":") ? ResourceLocation.tryParse((String)path) : new ResourceLocation(bookLink.bookId.getNamespace(), path);
            try {
                bookLink.pageNumber = Integer.parseInt(postHash);
            }
            catch (NumberFormatException e) {
                BookErrorManager.get().error("Invalid page number in entry link: " + linkText, e);
            }
            return bookLink;
        }
        bookLink.entryId = entryId.contains(":") ? ResourceLocation.tryParse((String)entryId) : new ResourceLocation(bookLink.bookId.getNamespace(), entryId);
        return bookLink;
    }

    public static PatchouliLink from(String linkText) {
        if (linkText.toLowerCase().startsWith(PROTOCOL_PATCHOULI)) {
            return PatchouliLink.fromEntry(linkText);
        }
        throw new IllegalArgumentException("Invalid patchouli link, does not start with \"patchouli://\": " + linkText);
    }

    public static boolean isPatchouliLink(String linkText) {
        return linkText.toLowerCase().startsWith(PROTOCOL_PATCHOULI);
    }
}

