/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookRecipePage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BookCraftingRecipePage
extends BookRecipePage<Recipe<?>> {
    public BookCraftingRecipePage(BookTextHolder title1, ResourceLocation recipeId1, BookTextHolder title2, ResourceLocation recipeId2, BookTextHolder text, String anchor, BookCondition condition) {
        super(RecipeType.CRAFTING, title1, recipeId1, title2, recipeId2, text, anchor, condition);
    }

    public static BookCraftingRecipePage fromJson(JsonObject json) {
        BookRecipePage.DataHolder common = BookRecipePage.commonFromJson(json);
        String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
        BookCondition condition = json.has("condition") ? BookCondition.fromJson(json.getAsJsonObject("condition")) : new BookNoneCondition();
        return new BookCraftingRecipePage(common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), anchor, condition);
    }

    public static BookCraftingRecipePage fromNetwork(FriendlyByteBuf buffer) {
        BookRecipePage.DataHolder common = BookRecipePage.commonFromNetwork(buffer);
        String anchor = buffer.readUtf();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        return new BookCraftingRecipePage(common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), anchor, condition);
    }

    @Override
    protected ItemStack getRecipeOutput(Level level, RecipeHolder<Recipe<?>> recipe) {
        if (recipe == null) {
            return ItemStack.EMPTY;
        }
        return recipe.value().getResultItem(level.registryAccess());
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Page.CRAFTING_RECIPE;
    }
}

