/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookStatesSaveData;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStates;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.RequestSyncBookStatesMessage;
import com.klikli_dev.modonomicon.networking.SyncBookUnlockStatesMessage;
import com.klikli_dev.modonomicon.platform.Services;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class BookUnlockStateManager {
    private static final BookUnlockStateManager instance = new BookUnlockStateManager();
    public BookStatesSaveData saveData;
    protected ScheduledExecutorService updateAndSyncTimer;

    public static BookUnlockStateManager get() {
        return instance;
    }

    private BookUnlockStates getStateFor(Player player) {
        this.getSaveDataIfNecessary(player);
        return this.saveData.getUnlockStates(player.getUUID());
    }

    public String getUnlockCodeFor(Player player, Book book) {
        return this.getStateFor(player).getUnlockCode(book);
    }

    public Book applyUnlockCodeFor(ServerPlayer player, String unlockCode) {
        Book book = this.getStateFor((Player)player).applyUnlockCode(unlockCode);
        if (book != null) {
            this.saveData.setDirty();
            this.syncFor(player);
        }
        return book;
    }

    public void syncFor(ServerPlayer player) {
        Services.NETWORK.sendTo(player, new SyncBookUnlockStatesMessage(this.getStateFor((Player)player)));
    }

    public void updateAndSyncFor(final ServerPlayer player) {
        if (BookDataManager.get().areBooksBuilt()) {
            this.getStateFor((Player)player).update(player);
            this.saveData.setDirty();
            this.syncFor(player);
        } else {
            if (this.updateAndSyncTimer != null && this.updateAndSyncTimer.isShutdown()) {
                this.updateAndSyncTimer = null;
            }
            if (this.updateAndSyncTimer == null) {
                this.updateAndSyncTimer = Executors.newSingleThreadScheduledExecutor();
            }
            final ScheduledExecutorService currentTimer = this.updateAndSyncTimer;
            this.updateAndSyncTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    player.server.execute(() -> {
                        BookUnlockStateManager.this.updateAndSyncFor(player);
                        currentTimer.shutdown();
                    });
                }
            }, 5L, TimeUnit.SECONDS);
        }
    }

    public List<ResourceLocation> getBooksFor(Player player) {
        return this.getStateFor(player).getBooks();
    }

    public void resetFor(ServerPlayer player, Book book) {
        this.getStateFor((Player)player).reset(book);
        this.saveData.setDirty();
        this.syncFor(player);
    }

    public boolean isUnlockedFor(Player player, BookCategory category) {
        return this.getStateFor(player).isUnlocked(category);
    }

    public boolean isUnlockedFor(Player player, BookEntry entry) {
        return this.getStateFor(player).isUnlocked(entry);
    }

    public boolean isUnlockedFor(Player player, BookPage page) {
        return this.getStateFor(player).isUnlocked(page);
    }

    public List<BookPage> getUnlockedPagesFor(Player player, BookEntry entry) {
        return this.getStateFor(player).getUnlockedPagesIn(entry);
    }

    public boolean isReadFor(Player player, BookEntry entry) {
        return this.getStateFor(player).isRead(entry);
    }

    public boolean canRunFor(Player player, BookCommand command) {
        return this.getStateFor(player).canRun(command);
    }

    public void setRunFor(Player player, BookCommand command) {
        this.getStateFor(player).setRun(command);
    }

    public boolean readFor(ServerPlayer player, BookEntry entry) {
        return this.getStateFor((Player)player).read(entry, player);
    }

    public void onAdvancement(ServerPlayer player) {
        this.updateAndSyncFor(player);
    }

    private void getSaveDataIfNecessary(Player player) {
        if (this.saveData == null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.saveData = (BookStatesSaveData)serverPlayer.getServer().overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(BookStatesSaveData::new, BookStatesSaveData::load, DataFixTypes.PLAYER), "modonomicon_book_states");
            } else {
                this.saveData = new BookStatesSaveData();
                Services.NETWORK.sendToServer(new RequestSyncBookStatesMessage());
                Modonomicon.LOG.error("Tried to get Modonomicon save data for player on client side, but was not set. This should not happen. Requesting a sync from the server. Please re-open the book in a few seconds to see your progress.");
            }
        }
    }
}

