/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookLink;
import com.klikli_dev.modonomicon.book.CommandLink;
import com.klikli_dev.modonomicon.book.PatchouliLink;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.entries.ContentBookEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookOverviewScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookPaginatedScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.BackButton;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ItemLinkRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.fluid.FluidHolder;
import com.klikli_dev.modonomicon.integration.ModonomiconJeiIntegration;
import com.klikli_dev.modonomicon.networking.ClickCommandLinkMessage;
import com.klikli_dev.modonomicon.networking.SaveEntryStateMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.platform.services.FluidHelper;
import com.klikli_dev.modonomicon.util.ItemStackUtil;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookContentScreen
extends BookPaginatedScreen {
    public static final int TOP_PADDING = 15;
    public static final int LEFT_PAGE_X = 12;
    public static final int RIGHT_PAGE_X = 141;
    public static final int PAGE_WIDTH = 124;
    public static final int PAGE_HEIGHT = 128;
    public static final int MAX_TITLE_WIDTH = 120;
    public static final int CLICK_SAFETY_MARGIN = 20;
    private static long lastTurnPageSoundTime;
    private final ContentBookEntry entry;
    private final ResourceLocation bookContentTexture;
    public int ticksInBook;
    public boolean simulateEscClosing;
    private List<BookPage> unlockedPages;
    private BookPage leftPage;
    private BookPage rightPage;
    private BookPageRenderer<?> leftPageRenderer;
    private BookPageRenderer<?> rightPageRenderer;
    private int openPagesIndex;
    private List<Component> tooltip;
    private ItemStack tooltipStack;
    private FluidHolder tooltipFluidStack;
    private boolean isHoveringItemLink;

    public BookContentScreen(BookOverviewScreen parentScreen, ContentBookEntry entry) {
        super((Component)Component.literal((String)""), parentScreen);
        this.minecraft = Minecraft.getInstance();
        this.entry = entry;
        this.bookContentTexture = this.parentScreen.getBook().getBookContentTexture();
        this.loadEntryState();
    }

    public static void drawFromTexture(GuiGraphics guiGraphics, Book book, int x, int y, int u, int v, int w, int h) {
        guiGraphics.blit(book.getBookContentTexture(), x, y, (float)u, (float)v, w, h, 512, 256);
    }

    public static void drawTitleSeparator(GuiGraphics guiGraphics, Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x - w / 2;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        BookContentScreen.drawFromTexture(guiGraphics, book, rx, y, 0, 253, w, h);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLock(GuiGraphics guiGraphics, Book book, int x, int y) {
        BookContentScreen.drawFromTexture(guiGraphics, book, x, y, 496, 0, 16, 16);
    }

    public static void playTurnPageSound(Book book) {
        if (ClientTicks.ticks - lastTurnPageSoundTime > 6L) {
            SoundEvent sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(book.getTurnPageSound());
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)((float)(0.7 + Math.random() * 0.3))));
            lastTurnPageSoundTime = ClientTicks.ticks;
        }
    }

    public static void renderBookBackground(GuiGraphics guiGraphics, ResourceLocation bookContentTexture) {
        int x = 0;
        int y = 0;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(bookContentTexture, x, y, 0.0f, 0.0f, 272, 178, 512, 256);
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public ContentBookEntry getEntry() {
        return this.entry;
    }

    @Override
    public Book getBook() {
        return this.entry.getBook();
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 2 < this.unlockedPages.size();
    }

    public void setTooltip(Component ... strings) {
        this.setTooltip(List.of(strings));
    }

    @Override
    public void setTooltip(List<Component> tooltip) {
        this.resetTooltip();
        this.tooltip = tooltip;
    }

    public void setTooltipStack(ItemStack stack) {
        this.resetTooltip();
        this.tooltipStack = stack;
    }

    public void setTooltipStack(FluidHolder stack) {
        this.resetTooltip();
        this.tooltipFluidStack = stack;
    }

    public boolean isMouseInRelativeRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = absMx;
        double my = absMy;
        return mx > (double)x && my > (double)y && mx <= (double)(x + w) && my <= (double)(y + h);
    }

    public double getRelativeX(double absX) {
        return absX - (double)this.bookLeft;
    }

    public double getRelativeY(double absY) {
        return absY - (double)this.bookTop;
    }

    public void renderItemStack(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, ItemStack stack) {
        if (stack.isEmpty() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }
        guiGraphics.renderItem(stack, x, y);
        guiGraphics.renderItemDecorations(this.font, stack, x, y);
        if (this.isMouseInRelativeRange(mouseX, mouseY, x, y, 16, 16)) {
            this.setTooltipStack(stack);
        }
    }

    public void renderItemStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<ItemStack> stacks) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, stacks, -1);
    }

    public void renderItemStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<ItemStack> stacks, int countOverride) {
        List<ItemStack> filteredStacks = PageRendererRegistry.filterRenderableItemStacks(stacks);
        if (filteredStacks.size() > 0) {
            ItemStack currentStack = filteredStacks.get(this.ticksInBook / 20 % filteredStacks.size());
            this.renderItemStack(guiGraphics, x, y, mouseX, mouseY, countOverride > 0 ? currentStack.copyWithCount(countOverride) : currentStack);
        }
    }

    public void renderIngredient(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Ingredient ingr) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, Arrays.asList(ingr.getItems()), -1);
    }

    public void renderIngredient(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Ingredient ingr, int countOverride) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, Arrays.asList(ingr.getItems()), countOverride);
    }

    public void renderFluidStack(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack) {
        this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, stack, 1000);
    }

    public void renderFluidStack(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack, int capacity) {
        if (stack.isEmpty() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        ClientServices.FLUID.drawFluid(guiGraphics, 18, 18, stack, capacity);
        guiGraphics.pose().popPose();
        if (this.isMouseInRelativeRange(mouseX, mouseY, x, y, 18, 18)) {
            this.setTooltipStack(stack);
        }
    }

    public void renderFluidStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks) {
        this.renderFluidStacks(guiGraphics, x, y, mouseX, mouseY, stacks, 1000);
    }

    public void renderFluidStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks, int capacity) {
        List<FluidHolder> filteredStacks = PageRendererRegistry.filterRenderableFluidStacks(stacks);
        if (filteredStacks.size() > 0) {
            this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, filteredStacks.get(this.ticksInBook / 20 % filteredStacks.size()), capacity);
        }
    }

    private int getOpenPagesIndexForPage(int pageIndex) {
        for (int i = 0; i < this.unlockedPages.size(); ++i) {
            int pageNumber = this.unlockedPages.get(i).getPageNumber();
            if (pageNumber == pageIndex) {
                return i & 0xFFFFFFFE;
            }
            if (pageNumber > pageIndex) break;
        }
        return 0;
    }

    public void goToPage(int pageIndex, boolean playSound) {
        int openPagesIndex = this.getOpenPagesIndexForPage(pageIndex);
        if (openPagesIndex >= 0 && openPagesIndex < this.unlockedPages.size()) {
            if (this.openPagesIndex != openPagesIndex) {
                this.openPagesIndex = openPagesIndex;
                this.onPageChanged();
                if (playSound) {
                    BookContentScreen.playTurnPageSound(this.getBook());
                }
            }
        } else {
            Modonomicon.LOG.warn("Tried to change to page index {} corresponding with openPagesIndex {} but max open pages index is {}.", new Object[]{pageIndex, openPagesIndex, this.unlockedPages.size()});
        }
    }

    public Style getClickedComponentStyleAtForPage(BookPageRenderer<?> page, double pMouseX, double pMouseY) {
        if (page != null) {
            return page.getClickedComponentStyleAt(pMouseX - (double)this.bookLeft - (double)page.left, pMouseY - (double)this.bookTop - (double)page.top);
        }
        return null;
    }

    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        Style leftPageClickedStyle = this.getClickedComponentStyleAtForPage(this.leftPageRenderer, pMouseX, pMouseY);
        if (leftPageClickedStyle != null) {
            return leftPageClickedStyle;
        }
        return this.getClickedComponentStyleAtForPage(this.rightPageRenderer, pMouseX, pMouseY);
    }

    public int getBookLeft() {
        return this.bookLeft;
    }

    public int getBookTop() {
        return this.bookTop;
    }

    public void removeRenderableWidgets(@NotNull Collection<? extends Renderable> renderables) {
        this.renderables.removeIf(renderables::contains);
        this.children().removeIf(c -> c instanceof Renderable && renderables.contains(c));
        this.narratables.removeIf(n -> n instanceof Renderable && renderables.contains(n));
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? (this.openPagesIndex -= 2) : (this.openPagesIndex += 2);
            this.onPageChanged();
            if (playSound) {
                BookContentScreen.playTurnPageSound(this.getBook());
            }
        }
    }

    protected void drawTooltip(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        if (this.tooltipStack != null) {
            List<Component> tooltip = this.getTooltipFromItem(this.tooltipStack);
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, tooltip, pMouseX, pMouseY);
        } else if (this.tooltipFluidStack != null) {
            List<Component> tooltip = this.getTooltipFromFluid(this.tooltipFluidStack);
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, tooltip, pMouseX, pMouseY);
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, this.tooltip, pMouseX, pMouseY);
        }
    }

    protected boolean clickPage(BookPageRenderer<?> page, double mouseX, double mouseY, int mouseButton) {
        if (page != null) {
            return page.mouseClicked(mouseX - (double)this.bookLeft - (double)page.left, mouseY - (double)this.bookTop - (double)page.top, mouseButton);
        }
        return false;
    }

    protected void renderPage(GuiGraphics guiGraphics, BookPageRenderer<?> page, int pMouseX, int pMouseY, float pPartialTick) {
        if (page == null) {
            return;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)page.left, (float)page.top, 0.0f);
        page.render(guiGraphics, pMouseX - this.bookLeft - page.left, pMouseY - this.bookTop - page.top, pPartialTick);
        guiGraphics.pose().popPose();
    }

    protected void beginDisplayPages() {
        if (this.leftPageRenderer != null) {
            this.leftPageRenderer.onEndDisplayPage(this);
        }
        if (this.rightPageRenderer != null) {
            this.rightPageRenderer.onEndDisplayPage(this);
        }
        int leftPageIndex = this.openPagesIndex;
        int rightPageIndex = leftPageIndex + 1;
        this.leftPage = leftPageIndex < this.unlockedPages.size() ? this.unlockedPages.get(leftPageIndex) : null;
        BookPage bookPage = this.rightPage = rightPageIndex < this.unlockedPages.size() ? this.unlockedPages.get(rightPageIndex) : null;
        if (this.leftPage != null) {
            this.leftPageRenderer = PageRendererRegistry.getPageRenderer(this.leftPage.getType()).create(this.leftPage);
            this.leftPageRenderer.onBeginDisplayPage(this, 12, 15);
        } else {
            this.leftPageRenderer = null;
        }
        if (this.rightPage != null) {
            this.rightPageRenderer = PageRendererRegistry.getPageRenderer(this.rightPage.getType()).create(this.rightPage);
            this.rightPageRenderer.onBeginDisplayPage(this, 141, 15);
        } else {
            this.rightPageRenderer = null;
        }
    }

    protected void onPageChanged() {
        this.beginDisplayPages();
    }

    protected void resetTooltip() {
        this.tooltip = null;
        this.tooltipStack = null;
        this.tooltipFluidStack = null;
    }

    private void loadEntryState() {
        EntryVisualState state = BookVisualStateManager.get().getEntryStateFor((Player)this.parentScreen.getMinecraft().player, this.entry);
        BookGuiManager.get().currentEntry = this.entry;
        BookGuiManager.get().currentContentScreen = this;
        if (state != null) {
            this.openPagesIndex = state.openPagesIndex;
        }
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.disableDepthTest();
        this.resetTooltip();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, -1300.0f);
        this.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.bookLeft, (float)this.bookTop, 0.0f);
        BookContentScreen.renderBookBackground(guiGraphics, this.bookContentTexture);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.bookLeft, (float)this.bookTop, 0.0f);
        this.renderPage(guiGraphics, this.leftPageRenderer, pMouseX, pMouseY, pPartialTick);
        this.renderPage(guiGraphics, this.rightPageRenderer, pMouseX, pMouseY, pPartialTick);
        guiGraphics.pose().popPose();
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }

    public void onClose() {
        if (this.simulateEscClosing || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)256)) {
            Services.NETWORK.sendToServer(new SaveEntryStateMessage(this.entry, this.openPagesIndex));
            super.onClose();
            this.parentScreen.onClose();
            this.simulateEscClosing = false;
        } else {
            Services.NETWORK.sendToServer(new SaveEntryStateMessage(this.entry, ClientServices.CLIENT_CONFIG.storeLastOpenPageWhenClosingEntry() ? this.openPagesIndex : 0));
            this.parentScreen.getCurrentCategoryScreen().onCloseEntry(this);
            ClientServices.GUI.popGuiLayer();
        }
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T pWidget) {
        return (T)super.addRenderableWidget(pWidget);
    }

    public void renderComponentHoverEffect(GuiGraphics guiGraphics, @Nullable Style style, int mouseX, int mouseY) {
        ClickEvent clickEvent;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
        Style newStyle = style;
        if (style != null && style.getHoverEvent() != null && style.getHoverEvent().getAction() == HoverEvent.Action.SHOW_TEXT && (clickEvent = style.getClickEvent()) != null) {
            Book book;
            Object link;
            if (clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE && BookLink.isBookLink(clickEvent.getValue())) {
                link = BookLink.from(this.getBook(), clickEvent.getValue());
                book = BookDataManager.get().getBook(((BookLink)link).bookId);
                if (((BookLink)link).entryId != null) {
                    BookEntry entry = book.getEntry(((BookLink)link).entryId);
                    Integer page = ((BookLink)link).pageNumber;
                    if (((BookLink)link).pageAnchor != null) {
                        page = entry.getPageNumberForAnchor(((BookLink)link).pageAnchor);
                    }
                    if (!BookUnlockStateManager.get().isUnlockedFor((Player)this.minecraft.player, entry)) {
                        oldComponent = (Component)style.getHoverEvent().getValue(HoverEvent.Action.SHOW_TEXT);
                        MutableComponent newComponent = Component.translatable((String)"modonomicon.gui.hover.book_link_locked", (Object[])new Object[]{oldComponent, Component.translatable((String)"modonomicon.gui.hover.book_entry_link_locked_info").withStyle(s -> s.withColor(16711701).withBold(Boolean.valueOf(true))).append("\n").append((Component)Component.translatable((String)"modonomicon.gui.hover.book_entry_link_locked_info.hint", (Object[])new Object[]{Component.translatable((String)entry.getCategory().getName()).withStyle(s -> s.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)))}).withStyle(s -> s.withBold(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE)))});
                        newStyle = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)newComponent));
                    } else if (page != null && !BookUnlockStateManager.get().isUnlockedFor((Player)this.minecraft.player, entry.getPages().get(page))) {
                        oldComponent = (Component)style.getHoverEvent().getValue(HoverEvent.Action.SHOW_TEXT);
                        MutableComponent newComponent = Component.translatable((String)"modonomicon.gui.hover.book_link_locked", (Object[])new Object[]{oldComponent, Component.translatable((String)"modonomicon.gui.hover.book_page_link_locked_info").withStyle(s -> s.withColor(16711701).withBold(Boolean.valueOf(true))).append("\n").append((Component)Component.translatable((String)"modonomicon.gui.hover.book_page_link_locked_info.hint", (Object[])new Object[]{Component.translatable((String)entry.getName()).withStyle(s -> s.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true))), Component.translatable((String)entry.getCategory().getName()).withStyle(s -> s.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)))}).withStyle(s -> s.withBold(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE)))});
                        newStyle = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)newComponent));
                    }
                }
            }
            if (clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND && CommandLink.isCommandLink(clickEvent.getValue())) {
                link = CommandLink.from(this.getBook(), clickEvent.getValue());
                book = BookDataManager.get().getBook(((CommandLink)link).bookId);
                if (((CommandLink)link).commandId != null) {
                    BookCommand command = book.getCommand(((CommandLink)link).commandId);
                    Component oldComponent = (Component)style.getHoverEvent().getValue(HoverEvent.Action.SHOW_TEXT);
                    if (!BookUnlockStateManager.get().canRunFor((Player)this.minecraft.player, command)) {
                        MutableComponent hoverComponent = Component.translatable((String)"modonomicon.gui.hover.command_link.unavailable").withStyle(ChatFormatting.RED);
                        newStyle = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)hoverComponent));
                        oldComponent = hoverComponent;
                    }
                    if (BookContentScreen.hasShiftDown()) {
                        MutableComponent newComponent = oldComponent.copy().append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)command.getCommand()).withStyle(ChatFormatting.GRAY));
                        newStyle = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)newComponent));
                    }
                }
            }
        }
        if ((style = newStyle) != null && style.getHoverEvent() != null) {
            HoverEvent hoverevent = style.getHoverEvent();
            HoverEvent.ItemStackInfo hoverevent$itemstackinfo = (HoverEvent.ItemStackInfo)hoverevent.getValue(HoverEvent.Action.SHOW_ITEM);
            if (hoverevent$itemstackinfo != null) {
                if (style.getClickEvent() != null) {
                    this.isHoveringItemLink = true;
                }
                int backupWidth = this.width;
                this.width /= 2;
                guiGraphics.renderTooltip(this.minecraft.font, hoverevent$itemstackinfo.getItemStack(), mouseX, mouseY);
                this.width = backupWidth;
                this.isHoveringItemLink = false;
            } else {
                HoverEvent.EntityTooltipInfo hoverevent$entitytooltipinfo = (HoverEvent.EntityTooltipInfo)hoverevent.getValue(HoverEvent.Action.SHOW_ENTITY);
                if (hoverevent$entitytooltipinfo != null) {
                    if (this.minecraft.options.advancedItemTooltips) {
                        guiGraphics.renderComponentTooltip(this.minecraft.font, hoverevent$entitytooltipinfo.getTooltipLines(), mouseX, mouseY);
                    }
                } else {
                    Component component = (Component)hoverevent.getValue(HoverEvent.Action.SHOW_TEXT);
                    if (component != null) {
                        int width = this.width / 2 - mouseX - 10;
                        guiGraphics.renderTooltip(this.minecraft.font, this.minecraft.font.split((FormattedText)component, width), mouseX, mouseY);
                    }
                }
            }
        }
        guiGraphics.pose().popPose();
    }

    public List<Component> getTooltipFromItem(ItemStack pItemStack) {
        List tooltip = BookContentScreen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)pItemStack);
        if (this.isHoveringItemLink) {
            tooltip.add(Component.literal((String)""));
            if (ModonomiconJeiIntegration.get().isJeiLoaded()) {
                tooltip.add(Component.translatable((String)"modonomicon.gui.hover.item_link_info").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN)));
                tooltip.add(Component.translatable((String)"modonomicon.gui.hover.item_link_info_line2").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY)));
            } else {
                tooltip.add(Component.translatable((String)"modonomicon.gui.hover.item_link_info.no_jei").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.RED)));
            }
        }
        return tooltip;
    }

    public List<Component> getTooltipFromFluid(FluidHolder fluidStack) {
        List<Component> tooltip = ClientServices.FLUID.getTooltip(fluidStack, 1000, (TooltipFlag)(this.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL), FluidHelper.TooltipMode.SHOW_AMOUNT_AND_CAPACITY);
        if (this.isHoveringItemLink) {
            tooltip.add((Component)Component.literal((String)""));
            if (ModonomiconJeiIntegration.get().isJeiLoaded()) {
                tooltip.add((Component)Component.translatable((String)"modonomicon.gui.hover.item_link_info").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN)));
                tooltip.add((Component)Component.translatable((String)"modonomicon.gui.hover.item_link_info_line2").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY)));
            } else {
                tooltip.add((Component)Component.translatable((String)"modonomicon.gui.hover.item_link_info.no_jei").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.RED)));
            }
        }
        return tooltip;
    }

    public boolean handleComponentClicked(@Nullable Style pStyle) {
        ClickEvent event;
        if (pStyle != null && (event = pStyle.getClickEvent()) != null) {
            Object link;
            if (event.getAction() == ClickEvent.Action.CHANGE_PAGE) {
                if (BookLink.isBookLink(event.getValue())) {
                    BookLink link2 = BookLink.from(this.getBook(), event.getValue());
                    Book book = BookDataManager.get().getBook(link2.bookId);
                    if (link2.entryId != null) {
                        BookEntry entry = book.getEntry(link2.entryId);
                        if (!BookUnlockStateManager.get().isUnlockedFor((Player)this.minecraft.player, entry)) {
                            return false;
                        }
                        Integer page = link2.pageNumber;
                        if (link2.pageAnchor != null) {
                            page = entry.getPageNumberForAnchor(link2.pageAnchor);
                        }
                        if (page != null && !BookUnlockStateManager.get().isUnlockedFor((Player)this.minecraft.player, entry.getPages().get(page))) {
                            return false;
                        }
                        if (page == null) {
                            page = 0;
                        }
                        int currentPageIndex = this.unlockedPages.get(this.openPagesIndex).getPageNumber();
                        BookGuiManager.get().pushHistory(this.entry.getBook().getId(), this.entry.getCategory().getId(), this.entry.getId(), currentPageIndex);
                        BookGuiManager.get().openEntry(link2.bookId, link2.entryId, page);
                    } else if (link2.categoryId != null) {
                        BookGuiManager.get().openEntry(link2.bookId, link2.categoryId, null, 0);
                    } else {
                        BookGuiManager.get().openEntry(link2.bookId, null, null, 0);
                    }
                    return true;
                }
                if (PatchouliLink.isPatchouliLink(event.getValue())) {
                    link = PatchouliLink.from(event.getValue());
                    if (((PatchouliLink)link).bookId != null) {
                        this.simulateEscClosing = true;
                        Services.PATCHOULI.openEntry(((PatchouliLink)link).bookId, ((PatchouliLink)link).entryId, ((PatchouliLink)link).pageNumber);
                        return true;
                    }
                }
                if (ItemLinkRenderer.isItemLink(event.getValue())) {
                    if (ModonomiconJeiIntegration.get().isJeiLoaded()) {
                        String itemId = event.getValue().substring(ItemLinkRenderer.PROTOCOL_ITEM_LENGTH);
                        ItemStack itemStack = ItemStackUtil.loadFromParsed(ItemStackUtil.parseItemStackString(itemId));
                        this.onClose();
                        if (Screen.hasShiftDown()) {
                            ModonomiconJeiIntegration.get().showUses(itemStack);
                        } else {
                            ModonomiconJeiIntegration.get().showRecipe(itemStack);
                        }
                        if (!ModonomiconJeiIntegration.get().isJEIRecipesGuiOpen()) {
                            ClientServices.GUI.pushGuiLayer(this);
                        }
                    }
                    return true;
                }
            }
            if (event.getAction() == ClickEvent.Action.RUN_COMMAND && CommandLink.isCommandLink(event.getValue())) {
                link = CommandLink.from(this.getBook(), event.getValue());
                Book book = BookDataManager.get().getBook(((CommandLink)link).bookId);
                if (((CommandLink)link).commandId != null) {
                    BookCommand command = book.getCommand(((CommandLink)link).commandId);
                    if (BookUnlockStateManager.get().canRunFor((Player)this.minecraft.player, command)) {
                        Services.NETWORK.sendToServer(new ClickCommandLinkMessage(((CommandLink)link).bookId, ((CommandLink)link).commandId));
                        if (this.minecraft.getSingleplayerServer() == null) {
                            BookUnlockStateManager.get().setRunFor((Player)this.minecraft.player, command);
                        }
                    }
                    return true;
                }
            }
        }
        return super.handleComponentClicked(pStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.unlockedPages = this.entry.getUnlockedPagesFor((Player)this.minecraft.player);
        this.beginDisplayPages();
        this.addRenderableWidget(new BackButton(this, this.width / 2 - 9, this.bookTop + 180 - 4));
    }

    public void tick() {
        super.tick();
        if (!BookContentScreen.hasShiftDown()) {
            ++this.ticksInBook;
        }
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        Style style;
        if (pButton == 0 && (style = this.getClickedComponentStyleAt(pMouseX, pMouseY)) != null && this.handleComponentClicked(style)) {
            return true;
        }
        if (super.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        boolean clickPage = this.clickPage(this.leftPageRenderer, pMouseX, pMouseY, pButton) || this.clickPage(this.rightPageRenderer, pMouseX, pMouseY, pButton);
        return clickPage || super.mouseClicked(pMouseX, pMouseY, pButton);
    }
}

