/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.client.gui.book.BookOverviewScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class SearchButton
extends Button {
    private final BookOverviewScreen parent;
    private final int scissorX;

    public SearchButton(BookOverviewScreen parent, int pX, int pY, int scissorX, int width, int height, Button.OnPress pOnPress, Tooltip tooltip) {
        super(pX, pY, width, height, (Component)Component.literal((String)""), pOnPress, Button.DEFAULT_NARRATION);
        this.setTooltip(tooltip);
        this.scissorX = scissorX;
        this.parent = parent;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.visible) {
            guiGraphics.pose().pushPose();
            int xOffset = this.parent.getBook().getSearchButtonXOffset();
            guiGraphics.pose().translate((float)xOffset, 0.0f, 0.0f);
            int scissorX = this.scissorX + xOffset;
            int texX = 15;
            int texY = 165;
            int renderX = this.getX();
            int scissorWidth = this.width + (this.getX() - this.scissorX);
            int scissorY = this.parent.height - this.getY() - this.height - 1;
            if (this.isHovered()) {
                ++renderX;
                --scissorWidth;
            }
            guiGraphics.enableScissor(scissorX, scissorY, scissorX + scissorWidth, scissorY + 1000);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(this.parent.getBookOverviewTexture(), renderX, this.getY(), (float)texX, (float)texY, this.width, this.height, 256, 256);
            guiGraphics.disableScissor();
            guiGraphics.pose().popPose();
        }
    }
}

