/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.multiblock.AbstractMultiblock;
import com.klikli_dev.modonomicon.multiblock.matcher.DisplayOnlyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;

public class MultiblockPreviewRenderer {
    public static boolean hasMultiblock;
    private static Map<BlockPos, BlockEntity> blockEntityCache;
    private static Set<BlockEntity> erroredBlockEntities;
    private static Multiblock multiblock;
    private static Component name;
    private static BlockPos pos;
    private static boolean isAnchored;
    private static Rotation facingRotation;
    private static Function<BlockPos, BlockPos> offsetApplier;
    private static int blocks;
    private static int blocksDone;
    private static int airFilled;
    private static int timeComplete;
    private static BlockState lookingState;
    private static BlockPos lookingPos;
    private static MultiBufferSource.BufferSource buffers;

    public static void setMultiblock(Multiblock multiblock, Component name, boolean flip) {
        MultiblockPreviewRenderer.setMultiblock(multiblock, name, flip, pos -> pos);
    }

    public static void setMultiblock(Multiblock multiblock, Component name, boolean flip, Function<BlockPos, BlockPos> offsetApplier) {
        if (flip && hasMultiblock) {
            hasMultiblock = false;
        } else {
            MultiblockPreviewRenderer.multiblock = multiblock;
            blockEntityCache = new HashMap<BlockPos, BlockEntity>();
            erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
            MultiblockPreviewRenderer.name = name;
            MultiblockPreviewRenderer.offsetApplier = offsetApplier;
            pos = null;
            hasMultiblock = multiblock != null;
            isAnchored = false;
        }
    }

    public static void onRenderHUD(GuiGraphics guiGraphics, float partialTicks) {
        if (hasMultiblock) {
            int fullAnimTime;
            int waitTime = 40;
            int fadeOutSpeed = 4;
            float animTime = (float)timeComplete + (timeComplete == 0 ? 0.0f : partialTicks);
            if (animTime > (float)(fullAnimTime = waitTime + 10)) {
                hasMultiblock = false;
                return;
            }
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, -Math.max(0.0f, animTime - (float)waitTime) * (float)fadeOutSpeed, 0.0f);
            Minecraft mc = Minecraft.getInstance();
            int x = mc.getWindow().getGuiScaledWidth() / 2;
            int y = 12;
            GuiGraphicsExt.drawString(guiGraphics, mc.font, name, (float)x - (float)mc.font.width((FormattedText)name) / 2.0f, (float)y, 0xFFFFFF, false);
            int width = 180;
            int height = 9;
            int left = x - width / 2;
            int top = y + 10;
            if (timeComplete > 0) {
                String s = I18n.get((String)"modonomicon.multiblock.complete", (Object[])new Object[0]);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, Math.min((float)(height + 5), animTime), 0.0f);
                guiGraphics.drawString(mc.font, s, (int)((float)x - (float)mc.font.width(s) / 2.0f), top + height - 10, 65280, false);
                guiGraphics.pose().popPose();
            }
            guiGraphics.fill(left - 1, top - 1, left + width + 1, top + height + 1, -16777216);
            MultiblockPreviewRenderer.drawGradientRect(guiGraphics, left, top, left + width, top + height, -10066330, -11184811);
            float fract = (float)blocksDone / (float)Math.max(1, blocks);
            int progressWidth = (int)((float)width * fract);
            int color = Mth.hsvToRgb((float)(fract / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
            int color2 = new Color(color).darker().getRGB();
            MultiblockPreviewRenderer.drawGradientRect(guiGraphics, left, top, left + progressWidth, top + height, color, color2);
            if (!isAnchored) {
                String s = I18n.get((String)"modonomicon.multiblock.not_anchored", (Object[])new Object[0]);
                guiGraphics.drawString(mc.font, s, (int)((float)x - (float)mc.font.width(s) / 2.0f), top + height + 8, 0xFFFFFF, false);
            } else {
                if (lookingState != null) {
                    try {
                        Block block = lookingState.getBlock();
                        ItemStack stack = block.getCloneItemStack((LevelReader)mc.level, lookingPos, lookingState);
                        if (!stack.isEmpty()) {
                            guiGraphics.drawString(mc.font, stack.getHoverName(), left + 20, top + height + 8, 0xFFFFFF, false);
                            guiGraphics.renderItem(stack, left, top + height + 2);
                        }
                    }
                    catch (Exception block) {
                        // empty catch block
                    }
                }
                if (timeComplete == 0) {
                    color = 0xFFFFFF;
                    int posx = left + width;
                    int posy = top + height + 2;
                    float mult = 1.0f;
                    Object progress = blocksDone + "/" + blocks;
                    if (blocksDone == blocks && airFilled > 0) {
                        progress = I18n.get((String)"modonomicon.multiblock.remove_blocks", (Object[])new Object[0]);
                        color = 14306879;
                        mult *= 2.0f;
                        posx -= width / 2;
                        posy += 2;
                    }
                    guiGraphics.drawString(mc.font, (String)progress, (int)((float)posx - (float)mc.font.width((String)progress) / mult), posy, color, true);
                }
            }
            guiGraphics.pose().popPose();
        }
    }

    public static void onRenderLevelLastEvent(PoseStack poseStack) {
        if (hasMultiblock && multiblock != null) {
            MultiblockPreviewRenderer.renderMultiblock((Level)Minecraft.getInstance().level, poseStack);
        }
    }

    public static void anchorTo(BlockPos target, Rotation rot) {
        pos = target;
        facingRotation = rot;
        isAnchored = true;
    }

    public static InteractionResult onPlayerInteract(Player player, Level world, InteractionHand hand, BlockHitResult hit) {
        if (hasMultiblock && !isAnchored && player == Minecraft.getInstance().player) {
            MultiblockPreviewRenderer.anchorTo(hit.getBlockPos(), MultiblockPreviewRenderer.getRotation((Entity)player));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void onClientTick(Minecraft mc) {
        if (Minecraft.getInstance().level == null) {
            hasMultiblock = false;
        } else if (isAnchored && blocks == blocksDone && airFilled == 0) {
            if (++timeComplete == 14) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.EXPERIENCE_ORB_PICKUP, (float)1.0f));
            }
        } else {
            timeComplete = 0;
        }
    }

    public static void renderMultiblock(Level level, PoseStack ms) {
        Minecraft mc = Minecraft.getInstance();
        if (!isAnchored) {
            facingRotation = MultiblockPreviewRenderer.getRotation((Entity)mc.player);
            if (mc.hitResult instanceof BlockHitResult) {
                pos = ((BlockHitResult)mc.hitResult).getBlockPos();
            }
        } else if (pos.distToCenterSqr((Position)mc.player.position()) > 4096.0) {
            return;
        }
        if (pos == null) {
            return;
        }
        if (multiblock.isSymmetrical()) {
            facingRotation = Rotation.NONE;
        }
        multiblock.setLevel(level);
        EntityRenderDispatcher erd = mc.getEntityRenderDispatcher();
        double renderPosX = erd.camera.getPosition().x();
        double renderPosY = erd.camera.getPosition().y();
        double renderPosZ = erd.camera.getPosition().z();
        ms.pushPose();
        ms.translate(-renderPosX, -renderPosY, -renderPosZ);
        if (buffers == null) {
            buffers = MultiblockPreviewRenderer.initBuffers(mc.renderBuffers().bufferSource());
        }
        BlockPos checkPos = null;
        HitResult hitResult = mc.hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockRes = (BlockHitResult)hitResult;
            checkPos = blockRes.getBlockPos().relative(blockRes.getDirection());
        }
        airFilled = 0;
        blocksDone = 0;
        blocks = 0;
        lookingState = null;
        lookingPos = checkPos;
        Pair<BlockPos, Collection<Multiblock.SimulateResult>> sim = multiblock.simulate(level, MultiblockPreviewRenderer.getStartPos(), MultiblockPreviewRenderer.getFacingRotation(), true, false);
        for (Multiblock.SimulateResult r : (Collection)sim.getSecond()) {
            boolean air;
            float alpha = 0.3f;
            if (r.getWorldPosition().equals((Object)checkPos)) {
                lookingState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks);
                alpha = 0.6f + (float)(Math.sin(ClientTicks.total * 0.3f) + 1.0) * 0.1f;
            }
            if (r.getStateMatcher().equals(Matchers.ANY) || r.getStateMatcher().getType() == DisplayOnlyMatcher.TYPE) continue;
            boolean bl = air = !r.getStateMatcher().countsTowardsTotalBlocks();
            if (!air) {
                ++blocks;
            }
            if (!r.test(level, facingRotation)) {
                BlockState renderState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).rotate(facingRotation);
                MultiblockPreviewRenderer.renderBlock(level, renderState, r.getWorldPosition(), multiblock, air, alpha, ms);
                Block block = renderState.getBlock();
                if (block instanceof EntityBlock) {
                    EntityBlock eb = (EntityBlock)block;
                    BlockEntity be = blockEntityCache.computeIfAbsent(r.getWorldPosition().immutable(), p -> eb.newBlockEntity(p, renderState));
                    if (be != null && !erroredBlockEntities.contains(be)) {
                        be.setLevel((Level)mc.level);
                        be.setBlockState(renderState);
                        ms.pushPose();
                        BlockPos bePos = r.getWorldPosition();
                        ms.translate((float)bePos.getX(), (float)bePos.getY(), (float)bePos.getZ());
                        try {
                            BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(be);
                            if (renderer != null) {
                                renderer.render(be, ClientTicks.partialTicks, ms, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.NO_OVERLAY);
                            }
                        }
                        catch (Exception e) {
                            erroredBlockEntities.add(be);
                            Modonomicon.LOG.error("Error rendering block entity", (Throwable)e);
                        }
                        ms.popPose();
                    }
                }
                if (!air) continue;
                ++airFilled;
                continue;
            }
            if (air) continue;
            ++blocksDone;
        }
        buffers.endBatch();
        ms.popPose();
        if (!isAnchored) {
            blocksDone = 0;
            blocks = 0;
        }
    }

    public static void renderBlock(Level world, BlockState state, BlockPos pos, Multiblock multiblock, boolean isAir, float alpha, PoseStack ms) {
        if (pos != null) {
            ms.pushPose();
            ms.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            if (state.getBlock() == Blocks.AIR) {
                float scale = 0.3f;
                float off = (1.0f - scale) / 2.0f;
                ms.translate(off, off, off);
                ms.scale(scale, scale, scale);
                state = Blocks.RED_CONCRETE.defaultBlockState();
            }
            ClientServices.MULTIBLOCK.renderBlock(state, pos, multiblock, ms, (MultiBufferSource)buffers, world.getRandom());
            ms.popPose();
        }
    }

    public static Multiblock getMultiblock() {
        return multiblock;
    }

    public static boolean isAnchored() {
        return isAnchored;
    }

    public static Rotation getFacingRotation() {
        return multiblock.isSymmetrical() ? Rotation.NONE : facingRotation;
    }

    public static BlockPos getStartPos() {
        return offsetApplier.apply(pos);
    }

    private static void drawGradientRect(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        bufferbuilder.vertex(mat, (float)right, (float)top, 0.0f).color(f1, f2, f3, f).endVertex();
        bufferbuilder.vertex(mat, (float)left, (float)top, 0.0f).color(f1, f2, f3, f).endVertex();
        bufferbuilder.vertex(mat, (float)left, (float)bottom, 0.0f).color(f5, f6, f7, f4).endVertex();
        bufferbuilder.vertex(mat, (float)right, (float)bottom, 0.0f).color(f5, f6, f7, f4).endVertex();
        tessellator.end();
        RenderSystem.disableBlend();
    }

    private static Rotation getRotation(Entity entity) {
        return AbstractMultiblock.rotationFromFacing(entity.getDirection());
    }

    private static MultiBufferSource.BufferSource initBuffers(MultiBufferSource.BufferSource original) {
        BufferBuilder fallback = original.builder;
        Map layerBuffers = original.fixedBuffers;
        Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry e : layerBuffers.entrySet()) {
            remapped.put(GhostRenderLayer.remap((RenderType)e.getKey()), (BufferBuilder)e.getValue());
        }
        return new GhostBuffers(fallback, (Map<RenderType, BufferBuilder>)remapped);
    }

    static {
        blockEntityCache = new Object2ObjectOpenHashMap();
        erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
        buffers = null;
    }

    private static class GhostRenderLayer
    extends RenderType {
        private static final Map<RenderType, RenderType> remappedTypes = new IdentityHashMap<RenderType, RenderType>();

        private GhostRenderLayer(RenderType original) {
            super(String.format("%s_%s_ghost", original.toString(), "modonomicon"), original.format(), original.mode(), original.bufferSize(), original.affectsCrumbling(), true, () -> {
                original.setupRenderState();
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }, () -> {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                original.clearRenderState();
            });
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof GhostRenderLayer) {
                return in;
            }
            return remappedTypes.computeIfAbsent(in, GhostRenderLayer::new);
        }
    }

    private static class GhostBuffers
    extends MultiBufferSource.BufferSource {
        protected GhostBuffers(BufferBuilder fallback, Map<RenderType, BufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public VertexConsumer getBuffer(RenderType type) {
            return super.getBuffer(GhostRenderLayer.remap(type));
        }
    }
}

