/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.markdown.MarkdownComponentRenderUtils;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class BookPageRenderer<T extends BookPage> {
    public int left;
    public int top;
    protected T page;
    protected BookContentScreen parentScreen;
    protected Minecraft mc;
    protected Font font;
    private List<Button> buttons = new ArrayList<Button>();

    public BookPageRenderer(T page) {
        this.page = page;
    }

    public static void renderBookTextHolder(GuiGraphics guiGraphics, BookTextHolder text, Font font, int x, int y, int width) {
        if (text.hasComponent()) {
            for (FormattedCharSequence formattedcharsequence : font.split((FormattedText)text.getComponent(), width)) {
                guiGraphics.drawString(font, formattedcharsequence, x, y, 0, false);
                Objects.requireNonNull(font);
                y += 9;
            }
        } else if (text instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
            List<MutableComponent> components = renderedText.getRenderedText();
            for (MutableComponent component : components) {
                List<FormattedCharSequence> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, width, width - 10, font);
                for (FormattedCharSequence formattedcharsequence : wrapped) {
                    guiGraphics.drawString(font, formattedcharsequence, x, y, 0, false);
                    Objects.requireNonNull(font);
                    y += 9;
                }
            }
        } else {
            Modonomicon.LOG.warn("BookTextHolder with String {} has no component, but is not rendered to markdown either.", (Object)text.getString());
        }
    }

    public void onBeginDisplayPage(BookContentScreen parentScreen, int left, int top) {
        this.parentScreen = parentScreen;
        this.mc = parentScreen.getMinecraft();
        this.font = this.mc.font;
        this.left = left;
        this.top = top;
        this.buttons = new ArrayList<Button>();
    }

    public T getPage() {
        return this.page;
    }

    public void onEndDisplayPage(BookContentScreen parentScreen) {
        parentScreen.removeRenderableWidgets(this.buttons);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return false;
    }

    public void renderBookTextHolder(GuiGraphics guiGraphics, BookTextHolder text, int x, int y, int width) {
        width += this.parentScreen.getBook().getBookTextOffsetWidth();
        BookPageRenderer.renderBookTextHolder(guiGraphics, text, this.font, x += this.parentScreen.getBook().getBookTextOffsetX(), y += this.parentScreen.getBook().getBookTextOffsetY(), width -= this.parentScreen.getBook().getBookTextOffsetX());
    }

    public void renderTitle(GuiGraphics guiGraphics, BookTextHolder title, boolean showTitleSeparator, int x, int y) {
        guiGraphics.pose().pushPose();
        if (title instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedTitle = (RenderedBookTextHolder)title;
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.fromList(renderedTitle.getRenderedText().stream().map(Component::getVisualOrderText).toList());
            float scale = Math.min(1.0f, 120.0f / (float)this.font.width(formattedCharSequence));
            if (scale < 1.0f) {
                guiGraphics.pose().translate(0.0f, (float)y - (float)y * scale, 0.0f);
                guiGraphics.pose().scale(scale, scale, scale);
            }
            this.drawCenteredStringNoShadow(guiGraphics, formattedCharSequence, x, y, 0, scale);
        } else if (title.hasComponent()) {
            ResourceLocation font = BookDataManager.Client.get().safeFont(((BookPage)this.page).getBook().getFont());
            MutableComponent titleComponent = Component.empty().append(title.getComponent()).withStyle(s -> s.withFont(font));
            float scale = Math.min(1.0f, 120.0f / (float)this.font.width(titleComponent.getVisualOrderText()));
            if (scale < 1.0f) {
                guiGraphics.pose().translate(0.0f, (float)y - (float)y * scale, 0.0f);
                guiGraphics.pose().scale(scale, scale, scale);
            }
            this.drawCenteredStringNoShadow(guiGraphics, titleComponent.getVisualOrderText(), x, y, 0, scale);
        } else {
            BookErrorManager.get().setTo((BookPage)this.page);
            BookErrorManager.get().error("Non-markdown title has no component.");
            BookErrorManager.get().getContextHelper().reset();
            BookErrorManager.get().setCurrentBookId(null);
        }
        guiGraphics.pose().popPose();
        if (showTitleSeparator) {
            BookContentScreen.drawTitleSeparator(guiGraphics, ((BookPage)this.page).getBook(), x, y + 12);
        }
    }

    public abstract void render(GuiGraphics var1, int var2, int var3, float var4);

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, FormattedCharSequence s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.width(s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        GuiGraphicsExt.drawString(guiGraphics, this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, String s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.width(s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        GuiGraphicsExt.drawString(guiGraphics, this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public void drawWrappedStringNoShadow(GuiGraphics guiGraphics, Component s, int x, int y, int color, int width) {
        for (FormattedCharSequence formattedcharsequence : this.font.split((FormattedText)s, width)) {
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, formattedcharsequence, x, y + 9, color, false);
            Objects.requireNonNull(this.font);
            y += 9;
        }
    }

    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        return null;
    }

    protected void addButton(Button button) {
        button.setX(button.getX() + this.parentScreen.getBookLeft() + this.left);
        button.setY(button.getY() + this.parentScreen.getBookTop() + this.top);
        this.buttons.add(button);
        this.parentScreen.addRenderableWidget(button);
    }

    @Nullable
    protected Style getClickedComponentStyleAtForTitle(BookTextHolder title, int x, int y, double pMouseX, double pMouseY) {
        if (title instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedTitle = (RenderedBookTextHolder)title;
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.fromList(renderedTitle.getRenderedText().stream().map(Component::getVisualOrderText).toList());
            if (pMouseY > (double)y) {
                Objects.requireNonNull(this.font);
                if (pMouseY < (double)(y + 9)) {
                    if (pMouseX < (double)(x -= this.font.width(formattedCharSequence) / 2)) {
                        return null;
                    }
                    return this.font.getSplitter().componentStyleAtWidth(formattedCharSequence, (int)pMouseX - x);
                }
            }
        } else if (pMouseY > (double)y) {
            Objects.requireNonNull(this.font);
            if (pMouseY < (double)(y + 9)) {
                FormattedCharSequence formattedCharSequence = title.getComponent().getVisualOrderText();
                if (pMouseX < (double)(x -= this.font.width(formattedCharSequence) / 2)) {
                    return null;
                }
                return this.font.getSplitter().componentStyleAtWidth(formattedCharSequence, (int)pMouseX - x);
            }
        }
        return null;
    }

    @Nullable
    protected Style getClickedComponentStyleAtForTextHolder(BookTextHolder text, int x, int y, int width, double pMouseX, double pMouseY) {
        block8: {
            block7: {
                if (!text.hasComponent()) break block7;
                for (FormattedCharSequence formattedcharsequence : this.font.split((FormattedText)text.getComponent(), width)) {
                    if (pMouseY > (double)y) {
                        Objects.requireNonNull(this.font);
                        if (pMouseY < (double)(y + 9)) {
                            return this.font.getSplitter().componentStyleAtWidth(formattedcharsequence, (int)pMouseX - x);
                        }
                    }
                    Objects.requireNonNull(this.font);
                    y += 9;
                }
                break block8;
            }
            if (!(text instanceof RenderedBookTextHolder)) break block8;
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
            List<MutableComponent> components = renderedText.getRenderedText();
            for (MutableComponent component : components) {
                List<FormattedCharSequence> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, width, width - 10, this.font);
                for (FormattedCharSequence formattedcharsequence : wrapped) {
                    if (pMouseY > (double)y) {
                        Objects.requireNonNull(this.font);
                        if (pMouseY < (double)(y + 9)) {
                            return this.font.getSplitter().componentStyleAtWidth(formattedcharsequence, (int)pMouseX - x);
                        }
                    }
                    Objects.requireNonNull(this.font);
                    y += 9;
                }
            }
        }
        return null;
    }
}

