/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.page.BookBlastingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookCampfireCookingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookCraftingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookEmptyPage;
import com.klikli_dev.modonomicon.book.page.BookEntityPage;
import com.klikli_dev.modonomicon.book.page.BookImagePage;
import com.klikli_dev.modonomicon.book.page.BookMultiblockPage;
import com.klikli_dev.modonomicon.book.page.BookProcessingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSmeltingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSmithingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSmokingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSpotlightPage;
import com.klikli_dev.modonomicon.book.page.BookStonecuttingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.client.render.page.BookCraftingRecipePageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookEmptyPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookEntityPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookImagePageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookMultiblockPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookProcessingRecipePageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookSmithingRecipePageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookSpotlightPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookTextPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererFactory;
import com.klikli_dev.modonomicon.fluid.FluidHolder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.material.Fluid;

public class PageRendererRegistry {
    static final Set<Item> ITEMS_NOT_TO_RENDER = ConcurrentHashMap.newKeySet();
    static final Set<Fluid> FLUIDS_NOT_TO_RENDER = ConcurrentHashMap.newKeySet();
    private static final Map<ResourceLocation, PageRendererFactory> pageRenderers = new ConcurrentHashMap<ResourceLocation, PageRendererFactory>();

    public static void registerPageRenderers() {
        PageRendererRegistry.registerDefaultPageRenderers();
    }

    private static void registerDefaultPageRenderers() {
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.TEXT, p -> new BookTextPageRenderer((BookTextPage)p));
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.MULTIBLOCK, p -> new BookMultiblockPageRenderer((BookMultiblockPage)p));
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.CRAFTING_RECIPE, p -> new BookCraftingRecipePageRenderer((BookCraftingRecipePage)p));
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.SMELTING_RECIPE, p -> new BookProcessingRecipePageRenderer<SmeltingRecipe>((BookProcessingRecipePage)((BookSmeltingRecipePage)p)){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.SMOKING_RECIPE, p -> new BookProcessingRecipePageRenderer<SmokingRecipe>((BookProcessingRecipePage)((BookSmokingRecipePage)p)){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.CAMPFIRE_COOKING_RECIPE, p -> new BookProcessingRecipePageRenderer<CampfireCookingRecipe>((BookProcessingRecipePage)((BookCampfireCookingRecipePage)p)){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.BLASTING_RECIPE, p -> new BookProcessingRecipePageRenderer<BlastingRecipe>((BookProcessingRecipePage)((BookBlastingRecipePage)p)){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.STONECUTTING_RECIPE, p -> new BookProcessingRecipePageRenderer<StonecutterRecipe>((BookProcessingRecipePage)((BookStonecuttingRecipePage)p)){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.SMITHING_RECIPE, p -> new BookSmithingRecipePageRenderer((BookSmithingRecipePage)p){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.SPOTLIGHT, p -> new BookSpotlightPageRenderer((BookSpotlightPage)p){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.EMPTY, p -> new BookEmptyPageRenderer((BookEmptyPage)p){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.ENTITY, p -> new BookEntityPageRenderer((BookEntityPage)p){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.IMAGE, p -> new BookImagePageRenderer((BookImagePage)p){});
    }

    public static void registerPageRenderer(ResourceLocation id, PageRendererFactory factory) {
        pageRenderers.put(id, factory);
    }

    public static PageRendererFactory getPageRenderer(ResourceLocation id) {
        PageRendererFactory renderer = pageRenderers.get(id);
        if (renderer == null) {
            throw new IllegalArgumentException("No page renderer registered for page type " + id);
        }
        return renderer;
    }

    public static void registerItemStackNotToRender(ItemStack stack) {
        ITEMS_NOT_TO_RENDER.add(stack.getItem());
    }

    public static void registerFluidStackNotToRender(FluidHolder stack) {
        FLUIDS_NOT_TO_RENDER.add(stack.getFluid());
    }

    public static boolean isRenderable(ItemStack stack) {
        return !ITEMS_NOT_TO_RENDER.contains(stack.getItem());
    }

    public static boolean isRenderable(FluidHolder stack) {
        return !FLUIDS_NOT_TO_RENDER.contains(stack.getFluid());
    }

    public static List<ItemStack> filterRenderableItemStacks(Collection<ItemStack> stacks) {
        return stacks.stream().filter(stack -> !ITEMS_NOT_TO_RENDER.contains(stack.getItem())).toList();
    }

    public static List<FluidHolder> filterRenderableFluidStacks(Collection<FluidHolder> stacks) {
        return stacks.stream().filter(stack -> !FLUIDS_NOT_TO_RENDER.contains(stack.getFluid())).toList();
    }
}

