/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookContextHelper;
import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookCommandModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookEntryReadConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookFalseConditionModel;
import com.klikli_dev.modonomicon.datagen.book.FeaturesCategoryProvider;
import com.klikli_dev.modonomicon.datagen.book.FormattingCategoryProvider;
import com.klikli_dev.modonomicon.datagen.book.OtherCategoryProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class DemoBookProvider
extends BookProvider {
    public DemoBookProvider(PackOutput packOutput, String modid, ModonomiconLanguageProvider lang, ModonomiconLanguageProvider ... translations) {
        super("demo", packOutput, modid, lang, translations);
    }

    @Override
    protected BookModel generateBook() {
        this.lang().add(this.context().bookName(), "Demo Book");
        this.lang().add(this.context().bookTooltip(), "A book to showcase & test Modonomicon features.");
        BookCategoryModel featuresCategory = new FeaturesCategoryProvider(this).generate();
        BookCategoryModel formattingCategory = new FormattingCategoryProvider(this).generate();
        BookCategoryModel hiddenCategory = this.makeHiddenCategory(this.context());
        BookCategoryModel conditionalCategory = this.makeConditionalCategory(this.context());
        conditionalCategory.withCondition(BookEntryReadConditionModel.create().withEntry(this.modLoc("features/condition_root")));
        BookCategoryModel otherCategory = new OtherCategoryProvider(this).generate();
        BookCommandModel commandEntryCommand = BookCommandModel.create(this.modLoc("test_command"), "/give @s minecraft:apple 1").withPermissionLevel(2).withSuccessMessage("modonomicon.command.test_command.success");
        this.lang.add(commandEntryCommand.getSuccessMessage(), "You got an apple, because reading is cool!");
        BookCommandModel commandEntryLinkCommand = BookCommandModel.create(this.modLoc("test_command2"), "/give @s minecraft:wheat 1").withPermissionLevel(2).withSuccessMessage("modonomicon.command.test_command2.success");
        this.lang.add(commandEntryLinkCommand.getSuccessMessage(), "You got wheat, because clicking is cool!");
        BookModel demoBook = BookModel.create(this.modLoc("demo"), this.context().bookName()).withTooltip(this.context().bookTooltip()).withModel(new ResourceLocation("modonomicon:modonomicon_green")).withBookTextOffsetX(5).withBookTextOffsetY(0).withBookTextOffsetWidth(-5).withCategory(featuresCategory).withCategory(formattingCategory).withCategory(hiddenCategory).withCategory(conditionalCategory).withCategory(otherCategory).withCommand(commandEntryCommand).withCommand(commandEntryLinkCommand);
        return demoBook;
    }

    @Override
    protected void registerDefaultMacros() {
    }

    private BookCategoryModel makeHiddenCategory(BookContextHelper helper) {
        this.context().category("hidden");
        CategoryEntryMap entryHelper = new CategoryEntryMap();
        entryHelper.setMap("_____________________", "_____________________", "__________l__________", "_____________________", "_____________________");
        this.context().entry("always_locked");
        BookEntryModel entry = BookEntryModel.create(this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)Items.NETHER_STAR).withLocation(entryHelper.get(Character.valueOf('l'))).withEntryBackground(0, 1).withCondition(BookFalseConditionModel.create());
        return BookCategoryModel.create(this.modLoc(this.context().categoryId()), this.context().categoryName()).withIcon((ItemLike)Items.BOOK).withShowCategoryButton(false).withEntry(entry);
    }

    private BookCategoryModel makeConditionalCategory(BookContextHelper helper) {
        this.context().category("conditional");
        CategoryEntryMap entryHelper = new CategoryEntryMap();
        entryHelper.setMap("_____________________", "_____________________", "__________l__________", "_____________________", "_____________________");
        this.context().entry("always_locked");
        BookEntryModel entry = BookEntryModel.create(this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)Items.NETHER_STAR).withLocation(entryHelper.get(Character.valueOf('l'))).withEntryBackground(0, 1).withCondition(BookFalseConditionModel.create());
        return BookCategoryModel.create(this.modLoc(this.context().categoryId()), this.context().categoryName()).withIcon((ItemLike)Blocks.CHEST).withEntry(entry);
    }
}

