/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookFalseConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class FormattingCategoryProvider
extends CategoryProvider {
    public FormattingCategoryProvider(BookProvider parent) {
        super(parent, "formatting");
    }

    @Override
    protected String[] generateEntryMap() {
        return new String[]{"_____________________", "__b___a______________", "__________l_____x____", "_____________________", "_____________________"};
    }

    @Override
    protected void generateEntries() {
        BookEntryModel basicFormattingEntry = this.add(this.makeBasicFormattingEntry('b'));
        BookEntryModel advancedFormattingEntry = this.add(this.makeAdvancedFormattingEntry('a'));
        BookEntryModel linkFormattingEntry = this.add(this.makeLinkFormattingEntry('l'));
        BookEntryModel alwaysLockedEntry = this.add(this.makeAlwaysLockedEntry('x'));
        alwaysLockedEntry.withCondition(BookFalseConditionModel.create());
        linkFormattingEntry.withParent(this.parent(advancedFormattingEntry));
        advancedFormattingEntry.withParent(this.parent(basicFormattingEntry));
    }

    @Override
    protected BookCategoryModel generateCategory() {
        return BookCategoryModel.create(this.modLoc(this.context().categoryId()), this.context().categoryName()).withIcon(new ResourceLocation("minecraft:textures/item/book.png"));
    }

    private BookEntryModel makeBasicFormattingEntry(char location) {
        this.context().entry("basic");
        this.context().page("page1");
        BookTextPageModel page1 = BookTextPageModel.create().withText(this.context().pageText()).withTitle(this.context().pageTitle());
        this.context().page("page2");
        BookTextPageModel page2 = BookTextPageModel.create().withText(this.context().pageText());
        BookEntryModel formattingEntry = this.entry(location).withIcon(new ResourceLocation("minecraft:textures/item/paper.png")).withPage(page1).withPage(page2);
        return formattingEntry;
    }

    private BookEntryModel makeAdvancedFormattingEntry(char location) {
        this.context().entry("advanced");
        this.context().page("page1");
        BookTextPageModel page1 = BookTextPageModel.create().withText(this.context().pageText()).withTitle(this.context().pageTitle());
        this.context().page("page2");
        BookTextPageModel page2 = BookTextPageModel.create().withText(this.context().pageText());
        this.context().page("page3");
        BookTextPageModel page3 = BookTextPageModel.create().withText(this.context().pageText()).withTitle(this.context().pageTitle());
        BookEntryModel formattingEntry = this.entry(location).withIcon((ItemLike)Items.FEATHER).withEntryBackground(0, 1).withPage(page1).withPage(page2).withPage(page3);
        return formattingEntry;
    }

    private BookEntryModel makeLinkFormattingEntry(char location) {
        this.context().entry("link");
        this.context().page("page1");
        BookTextPageModel page1 = BookTextPageModel.create().withText(this.context().pageText()).withTitle(this.context().pageTitle());
        this.context().page("page2");
        BookTextPageModel page2 = BookTextPageModel.create().withText(this.context().pageText()).withTitle(this.context().pageTitle());
        this.context().page("page3");
        BookTextPageModel page3 = BookTextPageModel.create().withText(this.context().pageText()).withTitle(this.context().pageTitle());
        return this.entry(location).withIcon((ItemLike)Items.WRITABLE_BOOK).withEntryBackground(0, 2).withPages(page1, page2, page3);
    }

    private BookEntryModel makeAlwaysLockedEntry(char location) {
        this.context().entry("always_locked");
        BookEntryModel entry = this.entry(location).withIcon((ItemLike)Items.NETHER_STAR).withLocation(this.entryMap().get(Character.valueOf(location))).withEntryBackground(0, 1);
        return entry;
    }
}

