/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.item;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ModonomiconItem
extends Item {
    public ModonomiconItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static Book getBook(ItemStack stack) {
        ResourceLocation res = ModonomiconItem.getBookId(stack);
        if (res == null) {
            return null;
        }
        return BookDataManager.get().getBook(res);
    }

    private static ResourceLocation getBookId(ItemStack stack) {
        if (!stack.hasTag() || !stack.getTag().contains("modonomicon:book_id")) {
            return null;
        }
        String bookStr = stack.getTag().getString("modonomicon:book_id");
        return ResourceLocation.tryParse((String)bookStr);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemInHand = pPlayer.getItemInHand(pUsedHand);
        if (pLevel.isClientSide) {
            if (itemInHand.hasTag()) {
                Book book = ModonomiconItem.getBook(itemInHand);
                BookGuiManager.get().openBook(book.getId());
            } else {
                Modonomicon.LOG.error("ModonomiconItem: ItemStack has no tag!");
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemInHand, (boolean)pLevel.isClientSide);
    }

    public Component getName(ItemStack pStack) {
        Book book = ModonomiconItem.getBook(pStack);
        if (book != null) {
            return Component.translatable((String)book.getName());
        }
        return super.getName(pStack);
    }

    public void appendHoverText(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        Book book = ModonomiconItem.getBook(stack);
        if (book != null) {
            if (flagIn.isAdvanced()) {
                tooltip.add((Component)Component.literal((String)"Book ID: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)book.getId().toString()).withStyle(ChatFormatting.RED)));
            }
            if (!book.getTooltip().isBlank()) {
                tooltip.add((Component)Component.translatable((String)book.getTooltip()).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.modonomicon.no_book_found_for_stack", (Object[])new Object[]{!stack.hasTag() ? Component.literal((String)"{}") : NbtUtils.toPrettyComponent((Tag)stack.getTag())}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

