/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.multiblock.AbstractMultiblock;
import com.klikli_dev.modonomicon.multiblock.SimulateResultImpl;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class DenseMultiblock
extends AbstractMultiblock {
    public static final ResourceLocation TYPE = Modonomicon.loc("dense");
    private static final Gson GSON = new GsonBuilder().create();
    private final String[][] pattern;
    private final Vec3i size;
    private final Map<Character, StateMatcher> targets;
    private StateMatcher[][][] stateMatchers;

    public DenseMultiblock(String[][] pattern, Map<Character, StateMatcher> targets) {
        this.pattern = pattern;
        this.targets = targets;
        if (!targets.containsKey(Character.valueOf('_'))) {
            targets.put(Character.valueOf('_'), Matchers.ANY);
        }
        if (!targets.containsKey(Character.valueOf(' '))) {
            targets.put(Character.valueOf(' '), Matchers.AIR);
        }
        if (!targets.containsKey(Character.valueOf('0'))) {
            targets.put(Character.valueOf('0'), Matchers.AIR);
        }
        this.size = this.build(targets, DenseMultiblock.getPatternDimensions(pattern));
    }

    public static DenseMultiblock fromNetwork(FriendlyByteBuf buffer) {
        boolean symmetrical = buffer.readBoolean();
        int offX = buffer.readVarInt();
        int offY = buffer.readVarInt();
        int offZ = buffer.readVarInt();
        int viewOffX = buffer.readVarInt();
        int viewOffY = buffer.readVarInt();
        int viewOffZ = buffer.readVarInt();
        int sizeX = buffer.readVarInt();
        int sizeY = buffer.readVarInt();
        String[][] pattern = new String[sizeY][sizeX];
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                pattern[y][x] = buffer.readUtf();
            }
        }
        Object2ObjectOpenHashMap targets = new Object2ObjectOpenHashMap();
        int targetCount = buffer.readVarInt();
        for (int i = 0; i < targetCount; ++i) {
            char key = buffer.readChar();
            ResourceLocation type = buffer.readResourceLocation();
            StateMatcher stateMatcher = LoaderRegistry.getStateMatcherNetworkLoader(type).fromNetwork(buffer);
            targets.put((Object)Character.valueOf(key), (Object)stateMatcher);
        }
        DenseMultiblock multiblock = new DenseMultiblock(pattern, (Map<Character, StateMatcher>)targets);
        multiblock.setSymmetrical(symmetrical);
        multiblock.setOffset(offX, offY, offZ);
        multiblock.setViewOffset(viewOffX, viewOffY, viewOffZ);
        return multiblock;
    }

    public static DenseMultiblock fromJson(JsonObject json) {
        String[][] pattern = (String[][])GSON.fromJson(json.get("pattern"), String[][].class);
        JsonObject jsonMapping = GsonHelper.getAsJsonObject((JsonObject)json, (String)"mapping");
        Map<Character, StateMatcher> mapping = DenseMultiblock.mappingFromJson(jsonMapping);
        DenseMultiblock multiblock = new DenseMultiblock(pattern, mapping);
        return DenseMultiblock.additionalPropertiesFromJson(multiblock, json);
    }

    private static Vec3i getPatternDimensions(String[][] pattern) {
        int expectedLenX = -1;
        int expectedLenZ = -1;
        for (String[] arr : pattern) {
            if (expectedLenX == -1) {
                expectedLenX = arr.length;
            }
            if (arr.length != expectedLenX) {
                throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + arr.length);
            }
            for (String s : arr) {
                if (expectedLenZ == -1) {
                    expectedLenZ = s.length();
                }
                if (s.length() == expectedLenZ) continue;
                throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + s.length());
            }
        }
        return new Vec3i(expectedLenX, pattern.length, expectedLenZ);
    }

    private Vec3i build(Map<Character, StateMatcher> stateMap, Vec3i dimensions) {
        boolean foundCenter = false;
        this.stateMatchers = new StateMatcher[dimensions.getX()][dimensions.getY()][dimensions.getZ()];
        for (int y = 0; y < dimensions.getY(); ++y) {
            for (int x = 0; x < dimensions.getX(); ++x) {
                for (int z = 0; z < dimensions.getZ(); ++z) {
                    char c = this.pattern[y][x].charAt(z);
                    if (!stateMap.containsKey(Character.valueOf(c))) {
                        throw new IllegalArgumentException("Character " + c + " isn't mapped");
                    }
                    StateMatcher matcher = stateMap.get(Character.valueOf(c));
                    if (c == '0') {
                        if (foundCenter) {
                            throw new IllegalArgumentException("A structure can't have two centers");
                        }
                        foundCenter = true;
                        this.offX = x;
                        this.offY = dimensions.getY() - y - 1;
                        this.offZ = z;
                        this.setViewOffset();
                    }
                    this.stateMatchers[x][dimensions.getY() - y - 1][z] = matcher;
                }
            }
        }
        if (!foundCenter) {
            throw new IllegalArgumentException("A structure can't have no center");
        }
        return dimensions;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public Pair<BlockPos, Collection<Multiblock.SimulateResult>> simulate(Level level, BlockPos anchor, Rotation rotation, boolean forView, boolean disableOffset) {
        BlockPos disp;
        BlockPos blockPos = disp = forView ? new BlockPos(-this.viewOffX, -this.viewOffY + 1, -this.viewOffZ).rotate(rotation) : new BlockPos(-this.offX, -this.offY, -this.offZ).rotate(rotation);
        if (disableOffset) {
            disp = BlockPos.ZERO;
        }
        BlockPos origin = anchor.offset((Vec3i)disp);
        ArrayList<SimulateResultImpl> ret = new ArrayList<SimulateResultImpl>();
        for (int x = 0; x < this.size.getX(); ++x) {
            for (int y = 0; y < this.size.getY(); ++y) {
                for (int z = 0; z < this.size.getZ(); ++z) {
                    BlockPos currDisp = new BlockPos(x, y, z).rotate(rotation);
                    BlockPos actionPos = origin.offset((Vec3i)currDisp);
                    char currC = this.pattern[y][x].charAt(z);
                    ret.add(new SimulateResultImpl(actionPos, this.stateMatchers[x][y][z], Character.valueOf(currC)));
                }
            }
        }
        return Pair.of((Object)origin, ret);
    }

    @Override
    public boolean test(Level level, BlockPos start, int x, int y, int z, Rotation rotation) {
        this.setLevel(level);
        if (x < 0 || y < 0 || z < 0 || x >= this.size.getX() || y >= this.size.getY() || z >= this.size.getZ()) {
            return false;
        }
        BlockPos checkPos = start.offset((Vec3i)new BlockPos(x, y, z).rotate(AbstractMultiblock.fixHorizontal(rotation)));
        TriPredicate<BlockGetter, BlockPos, BlockState> pred = this.stateMatchers[x][y][z].getStatePredicate();
        BlockState state = level.getBlockState(checkPos).rotate(rotation);
        return pred.test((BlockGetter)level, checkPos, state);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.symmetrical);
        buffer.writeVarInt(this.offX);
        buffer.writeVarInt(this.offY);
        buffer.writeVarInt(this.offZ);
        buffer.writeVarInt(this.viewOffX);
        buffer.writeVarInt(this.viewOffY);
        buffer.writeVarInt(this.viewOffZ);
        buffer.writeVarInt(this.size.getX());
        buffer.writeVarInt(this.size.getY());
        for (int y = 0; y < this.size.getY(); ++y) {
            for (int x = 0; x < this.size.getX(); ++x) {
                buffer.writeUtf(this.pattern[y][x]);
            }
        }
        buffer.writeVarInt(this.targets.size());
        for (Map.Entry<Character, StateMatcher> entry : this.targets.entrySet()) {
            buffer.writeChar((int)entry.getKey().charValue());
            buffer.writeResourceLocation(entry.getValue().getType());
            entry.getValue().toNetwork(buffer);
        }
    }

    @Override
    public Vec3i getSize() {
        return this.size;
    }

    public BlockState getBlockState(BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (x < 0 || y < 0 || z < 0 || x >= this.size.getX() || y >= this.size.getY() || z >= this.size.getZ()) {
            return Blocks.AIR.defaultBlockState();
        }
        long ticks = this.level != null ? this.level.getGameTime() : 0L;
        return this.stateMatchers[x][y][z].getDisplayedState(ticks);
    }
}

