/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.multiblock.AbstractMultiblock;
import com.klikli_dev.modonomicon.multiblock.SimulateResultImpl;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class SparseMultiblock
extends AbstractMultiblock {
    public static final ResourceLocation TYPE = Modonomicon.loc("sparse");
    private final Map<BlockPos, StateMatcher> stateMatchers;
    private final Vec3i size;

    public SparseMultiblock(Map<BlockPos, StateMatcher> stateMatchers) {
        Preconditions.checkArgument((!stateMatchers.isEmpty() ? 1 : 0) != 0, (Object)"No data given to sparse multiblock!");
        this.stateMatchers = ImmutableMap.copyOf(stateMatchers);
        this.size = this.calculateSize();
    }

    public static SparseMultiblock fromJson(JsonObject json) {
        JsonObject jsonMapping = GsonHelper.getAsJsonObject((JsonObject)json, (String)"mapping");
        Map<Character, StateMatcher> mapping = SparseMultiblock.mappingFromJson(jsonMapping);
        JsonObject jsonPattern = GsonHelper.getAsJsonObject((JsonObject)json, (String)"pattern");
        Object2ObjectOpenHashMap stateMatchers = new Object2ObjectOpenHashMap();
        for (Map.Entry entry : jsonPattern.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Pattern key needs to be only 1 character");
            }
            StateMatcher matcher = mapping.get(Character.valueOf(((String)entry.getKey()).charAt(0)));
            JsonArray jsonPositions = GsonHelper.convertToJsonArray((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
            for (JsonElement jsonPosition : jsonPositions) {
                JsonArray jsonPos = GsonHelper.convertToJsonArray((JsonElement)jsonPosition, (String)((String)entry.getKey()));
                if (jsonPos.size() != 3) {
                    throw new JsonSyntaxException("Each matcher position needs to be an array of 3 integers");
                }
                stateMatchers.put(new BlockPos(jsonPos.get(0).getAsInt(), jsonPos.get(1).getAsInt(), jsonPos.get(2).getAsInt()), matcher);
            }
        }
        SparseMultiblock multiblock = new SparseMultiblock((Map<BlockPos, StateMatcher>)stateMatchers);
        return SparseMultiblock.additionalPropertiesFromJson(multiblock, json);
    }

    public static SparseMultiblock fromNetwork(FriendlyByteBuf buffer) {
        boolean symmetrical = buffer.readBoolean();
        int offX = buffer.readVarInt();
        int offY = buffer.readVarInt();
        int offZ = buffer.readVarInt();
        int viewOffX = buffer.readVarInt();
        int viewOffY = buffer.readVarInt();
        int viewOffZ = buffer.readVarInt();
        int size = buffer.readVarInt();
        Object2ObjectOpenHashMap stateMatchers = new Object2ObjectOpenHashMap();
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buffer.readBlockPos();
            ResourceLocation type = buffer.readResourceLocation();
            StateMatcher matcher = LoaderRegistry.getStateMatcherNetworkLoader(type).fromNetwork(buffer);
            stateMatchers.put((Object)pos, (Object)matcher);
        }
        SparseMultiblock multiblock = new SparseMultiblock((Map<BlockPos, StateMatcher>)stateMatchers);
        multiblock.setSymmetrical(symmetrical);
        multiblock.setOffset(offX, offY, offZ);
        multiblock.setViewOffset(viewOffX, viewOffY, viewOffZ);
        return multiblock;
    }

    private Vec3i calculateSize() {
        int minX = this.stateMatchers.keySet().stream().mapToInt(Vec3i::getX).min().getAsInt();
        int maxX = this.stateMatchers.keySet().stream().mapToInt(Vec3i::getX).max().getAsInt();
        int minY = this.stateMatchers.keySet().stream().mapToInt(Vec3i::getY).min().getAsInt();
        int maxY = this.stateMatchers.keySet().stream().mapToInt(Vec3i::getY).max().getAsInt();
        int minZ = this.stateMatchers.keySet().stream().mapToInt(Vec3i::getZ).min().getAsInt();
        int maxZ = this.stateMatchers.keySet().stream().mapToInt(Vec3i::getZ).max().getAsInt();
        return new Vec3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
    }

    @Override
    public Vec3i getSize() {
        return this.size;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public Pair<BlockPos, Collection<Multiblock.SimulateResult>> simulate(Level world, BlockPos anchor, Rotation rotation, boolean forView, boolean disableOffset) {
        BlockPos disp;
        BlockPos blockPos = disp = forView ? new BlockPos(-this.viewOffX, -this.viewOffY + 1, -this.viewOffZ).rotate(rotation) : new BlockPos(-this.offX, -this.offY, -this.offZ).rotate(rotation);
        if (disableOffset) {
            disp = BlockPos.ZERO;
        }
        BlockPos origin = anchor.offset((Vec3i)disp);
        ArrayList<SimulateResultImpl> ret = new ArrayList<SimulateResultImpl>();
        for (Map.Entry<BlockPos, StateMatcher> e : this.stateMatchers.entrySet()) {
            BlockPos currDisp = e.getKey().rotate(rotation);
            BlockPos actionPos = origin.offset((Vec3i)currDisp);
            ret.add(new SimulateResultImpl(actionPos, e.getValue(), null));
        }
        return Pair.of((Object)origin, ret);
    }

    @Override
    public boolean test(Level world, BlockPos start, int x, int y, int z, Rotation rotation) {
        this.setLevel(world);
        BlockPos checkPos = start.offset((Vec3i)new BlockPos(x, y, z).rotate(rotation));
        BlockState state = world.getBlockState(checkPos).rotate(AbstractMultiblock.fixHorizontal(rotation));
        StateMatcher matcher = this.stateMatchers.getOrDefault(new BlockPos(x, y, z), Matchers.ANY);
        return matcher.getStatePredicate().test((BlockGetter)world, checkPos, state);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.symmetrical);
        buffer.writeVarInt(this.offX);
        buffer.writeVarInt(this.offY);
        buffer.writeVarInt(this.offZ);
        buffer.writeVarInt(this.viewOffX);
        buffer.writeVarInt(this.viewOffY);
        buffer.writeVarInt(this.viewOffZ);
        buffer.writeVarInt(this.stateMatchers.size());
        for (Map.Entry<BlockPos, StateMatcher> entry : this.stateMatchers.entrySet()) {
            buffer.writeBlockPos(entry.getKey());
            buffer.writeResourceLocation(entry.getValue().getType());
            entry.getValue().toNetwork(buffer);
        }
    }

    public BlockState getBlockState(BlockPos pos) {
        long ticks = this.level != null ? this.level.getGameTime() : 0L;
        return this.stateMatchers.getOrDefault(pos, Matchers.AIR).getDisplayedState(ticks);
    }
}

