/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.google.common.collect.Lists;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.networking.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.WorldData;

public class ReloadResourcesDoneMessage
implements Message {
    public static final ResourceLocation ID = new ResourceLocation("modonomicon", "reload_resources_done");

    public ReloadResourcesDoneMessage() {
    }

    public ReloadResourcesDoneMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        if (!player.hasPermissions(2)) {
            return;
        }
        PackRepository packrepository = minecraftServer.getPackRepository();
        WorldData worlddata = minecraftServer.getWorldData();
        Collection selectedIds = packrepository.getSelectedIds();
        Collection<String> packs = ReloadResourcesDoneMessage.discoverNewPacks(packrepository, worlddata, selectedIds);
        ReloadResourcesDoneMessage.reloadPacks(packs, player, minecraftServer);
    }

    private static Collection<String> discoverNewPacks(PackRepository pPackRepository, WorldData pWorldData, Collection<String> pSelectedIds) {
        pPackRepository.reload();
        ArrayList collection = Lists.newArrayList(pSelectedIds);
        List collection1 = pWorldData.getDataConfiguration().dataPacks().getDisabled();
        for (String s : pPackRepository.getAvailableIds()) {
            if (collection1.contains(s) || collection.contains(s)) continue;
            collection.add(s);
        }
        return collection;
    }

    public static void reloadPacks(Collection<String> pSelectedIds, ServerPlayer player, MinecraftServer server) {
        ((CompletableFuture)server.reloadResources(pSelectedIds).exceptionally(error -> {
            Modonomicon.LOG.warn("Failed to execute reload", error);
            player.sendSystemMessage((Component)Component.translatable((String)"commands.reload.failure").withStyle(ChatFormatting.RED));
            return null;
        })).thenRun(() -> {
            BookUnlockStateManager.get().updateAndSyncFor(player);
            player.sendSystemMessage((Component)Component.translatable((String)"modonomicon.command.success.reload_requested").withStyle(ChatFormatting.GREEN));
        });
    }
}

