/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.bookstate.BookStatesSaveData;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStates;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStates;
import com.klikli_dev.modonomicon.networking.Message;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SyncBookVisualStatesMessage
implements Message {
    public static final ResourceLocation ID = new ResourceLocation("modonomicon", "sync_book_visual_states");
    public BookVisualStates states;

    public SyncBookVisualStatesMessage(BookVisualStates states) {
        this.states = states;
    }

    public SyncBookVisualStatesMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeWithCodec((DynamicOps)NbtOps.INSTANCE, BookVisualStates.CODEC, (Object)this.states);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.states = (BookVisualStates)buf.readWithCodecTrusted((DynamicOps)NbtOps.INSTANCE, BookVisualStates.CODEC);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        if (minecraft.getSingleplayerServer() == null) {
            BookVisualStateManager.get().saveData = new BookStatesSaveData(new ConcurrentHashMap<UUID, BookUnlockStates>(), new ConcurrentHashMap<UUID, BookVisualStates>(Map.of(player.getUUID(), this.states)));
        }
    }
}

