/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin;

import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import squeek.appleskin.ModConfig;
import squeek.appleskin.client.DebugInfoHandler;
import squeek.appleskin.client.HUDOverlayHandler;
import squeek.appleskin.client.TooltipOverlayHandler;
import squeek.appleskin.network.SyncHandler;

@Mod(value="appleskin")
public class AppleSkin {
    public static Logger Log = LogManager.getLogger((String)"appleskin");

    public AppleSkin(IEventBus modEventBus) {
        modEventBus.addListener(this::onRegisterPayloadHandler);
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(this::preInitClient);
            modEventBus.addListener(this::onRegisterClientTooltipComponentFactories);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfig.SPEC);
        ModConfig.init(FMLPaths.CONFIGDIR.get().resolve("appleskin-client.toml"));
    }

    private void preInitClient(FMLClientSetupEvent event) {
        DebugInfoHandler.init();
        HUDOverlayHandler.init();
        TooltipOverlayHandler.init();
    }

    private void onRegisterClientTooltipComponentFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        TooltipOverlayHandler.register(event);
    }

    @SubscribeEvent
    private void onRegisterPayloadHandler(RegisterPayloadHandlerEvent event) {
        SyncHandler.register(event);
    }
}

