/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiOverlayEvent;
import net.neoforged.neoforge.client.gui.overlay.ExtendedGui;
import net.neoforged.neoforge.client.gui.overlay.GuiOverlayManager;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.event.HUDOverlayEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.HungerHelper;
import squeek.appleskin.helpers.TextureHelper;
import squeek.appleskin.util.IntPoint;

@OnlyIn(value=Dist.CLIENT)
public class HUDOverlayHandler {
    private static float unclampedFlashAlpha = 0.0f;
    private static float flashAlpha = 0.0f;
    private static byte alphaDir = 1;
    protected static int foodIconsOffset;
    public static final Vector<IntPoint> healthBarOffsets;
    public static final Vector<IntPoint> foodBarOffsets;
    private static final Random random;
    static ResourceLocation FOOD_LEVEL_ELEMENT;
    static ResourceLocation PLAYER_HEALTH_ELEMENT;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new HUDOverlayHandler());
    }

    @SubscribeEvent
    public void onRenderGuiOverlayPre(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)FOOD_LEVEL_ELEMENT)) {
            Minecraft mc = Minecraft.getInstance();
            ExtendedGui gui = (ExtendedGui)mc.gui;
            boolean isMounted = mc.player.getVehicle() instanceof LivingEntity;
            if (!isMounted && !mc.options.hideGui && gui.shouldDrawSurvivalElements()) {
                HUDOverlayHandler.renderExhaustion(gui, event.getGuiGraphics(), event.getPartialTick(), event.getWindow().getScreenWidth(), event.getWindow().getScreenHeight());
            }
        }
    }

    @SubscribeEvent
    public void onRenderGuiOverlayPost(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)FOOD_LEVEL_ELEMENT)) {
            Minecraft mc = Minecraft.getInstance();
            ExtendedGui gui = (ExtendedGui)mc.gui;
            boolean isMounted = mc.player.getVehicle() instanceof LivingEntity;
            if (!isMounted && !mc.options.hideGui && gui.shouldDrawSurvivalElements()) {
                HUDOverlayHandler.renderFoodOrHealthOverlay(gui, event.getGuiGraphics(), event.getPartialTick(), event.getWindow().getScreenWidth(), event.getWindow().getScreenHeight(), RenderOverlayType.FOOD);
            }
        } else if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)PLAYER_HEALTH_ELEMENT)) {
            Minecraft mc = Minecraft.getInstance();
            ExtendedGui gui = (ExtendedGui)mc.gui;
            if (!mc.options.hideGui && gui.shouldDrawSurvivalElements()) {
                HUDOverlayHandler.renderFoodOrHealthOverlay(gui, event.getGuiGraphics(), event.getPartialTick(), event.getWindow().getScreenWidth(), event.getWindow().getScreenHeight(), RenderOverlayType.HEALTH);
            }
        }
    }

    public static void renderExhaustion(ExtendedGui gui, GuiGraphics guiGraphics, float partialTicks, int screenWidth, int screenHeight) {
        foodIconsOffset = gui.rightHeight;
        if (!((Boolean)ModConfig.SHOW_FOOD_EXHAUSTION_UNDERLAY.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        assert (player != null);
        int right = mc.getWindow().getGuiScaledWidth() / 2 + 91;
        int top = mc.getWindow().getGuiScaledHeight() - foodIconsOffset;
        float exhaustion = player.getFoodData().getExhaustionLevel();
        HUDOverlayEvent.Exhaustion renderEvent = new HUDOverlayEvent.Exhaustion(exhaustion, right, top, guiGraphics);
        NeoForge.EVENT_BUS.post((Event)renderEvent);
        if (!renderEvent.isCanceled()) {
            HUDOverlayHandler.drawExhaustionOverlay(renderEvent, mc, 1.0f);
        }
    }

    public static void renderFoodOrHealthOverlay(ExtendedGui gui, GuiGraphics guiGraphics, float partialTicks, int screenWidth, int screenHeight, RenderOverlayType type) {
        boolean shouldRenderHeldItemValues;
        if (!HUDOverlayHandler.shouldRenderAnyOverlays()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        assert (player != null);
        FoodData stats = player.getFoodData();
        int top = mc.getWindow().getGuiScaledHeight() - foodIconsOffset;
        int left = mc.getWindow().getGuiScaledWidth() / 2 - 91;
        int right = mc.getWindow().getGuiScaledWidth() / 2 + 91;
        if (type == RenderOverlayType.HEALTH) {
            HUDOverlayHandler.generateHealthBarOffsets(top, left, right, mc.gui.getGuiTicks(), (Player)player);
        }
        if (type == RenderOverlayType.FOOD) {
            HUDOverlayHandler.generateHungerBarOffsets(top, left, right, mc.gui.getGuiTicks(), (Player)player);
        }
        HUDOverlayEvent.Saturation saturationRenderEvent = null;
        if (type == RenderOverlayType.FOOD) {
            saturationRenderEvent = new HUDOverlayEvent.Saturation(stats.getSaturationLevel(), right, top, guiGraphics);
            if (!((Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get()).booleanValue()) {
                saturationRenderEvent.setCanceled(true);
            }
            if (!saturationRenderEvent.isCanceled()) {
                NeoForge.EVENT_BUS.post((Event)saturationRenderEvent);
            }
            if (!saturationRenderEvent.isCanceled()) {
                HUDOverlayHandler.drawSaturationOverlay(saturationRenderEvent, mc, 0.0f, 1.0f);
            }
        }
        ItemStack heldItem = player.getMainHandItem();
        if (((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY_WHEN_OFFHAND.get()).booleanValue() && !FoodHelper.canConsume(heldItem, (Player)player)) {
            heldItem = player.getOffhandItem();
        }
        boolean bl = shouldRenderHeldItemValues = !heldItem.isEmpty() && FoodHelper.canConsume(heldItem, (Player)player);
        if (!shouldRenderHeldItemValues) {
            HUDOverlayHandler.resetFlash();
            return;
        }
        FoodValues modifiedFoodValues = FoodHelper.getModifiedFoodValues(heldItem, (Player)player);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent((Player)player, heldItem, FoodHelper.getDefaultFoodValues(heldItem, (Player)player), modifiedFoodValues);
        NeoForge.EVENT_BUS.post((Event)foodValuesEvent);
        modifiedFoodValues = foodValuesEvent.modifiedFoodValues;
        if (type == RenderOverlayType.HEALTH) {
            if (healthBarOffsets.size() == 0) {
                return;
            }
            if (!HUDOverlayHandler.shouldShowEstimatedHealth(heldItem, modifiedFoodValues)) {
                return;
            }
            float foodHealthIncrement = FoodHelper.getEstimatedHealthIncrement(heldItem, modifiedFoodValues, (Player)player);
            float currentHealth = player.getHealth();
            float modifiedHealth = Math.min(currentHealth + foodHealthIncrement, player.getMaxHealth());
            HUDOverlayEvent.HealthRestored healthRenderEvent = null;
            if (currentHealth < modifiedHealth) {
                healthRenderEvent = new HUDOverlayEvent.HealthRestored(modifiedHealth, heldItem, modifiedFoodValues, left, top, guiGraphics);
            }
            if (healthRenderEvent != null) {
                NeoForge.EVENT_BUS.post(healthRenderEvent);
            }
            if (healthRenderEvent != null && !healthRenderEvent.isCanceled()) {
                HUDOverlayHandler.drawHealthOverlay(healthRenderEvent, mc, flashAlpha);
            }
        } else if (type == RenderOverlayType.FOOD) {
            if (!((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY.get()).booleanValue()) {
                return;
            }
            HUDOverlayEvent.HungerRestored renderRenderEvent = new HUDOverlayEvent.HungerRestored(stats.getFoodLevel(), heldItem, modifiedFoodValues, right, top, guiGraphics);
            NeoForge.EVENT_BUS.post((Event)renderRenderEvent);
            if (renderRenderEvent.isCanceled()) {
                return;
            }
            int foodHunger = modifiedFoodValues.hunger;
            float foodSaturationIncrement = modifiedFoodValues.getSaturationIncrement();
            HUDOverlayHandler.drawHungerOverlay(renderRenderEvent, mc, foodHunger, flashAlpha, FoodHelper.isRotten(heldItem, (Player)player));
            assert (saturationRenderEvent != null);
            if (!saturationRenderEvent.isCanceled()) {
                int newFoodValue = stats.getFoodLevel() + foodHunger;
                float newSaturationValue = stats.getSaturationLevel() + foodSaturationIncrement;
                float saturationGained = newSaturationValue > (float)newFoodValue ? (float)newFoodValue - stats.getSaturationLevel() : foodSaturationIncrement;
                HUDOverlayHandler.drawSaturationOverlay(saturationRenderEvent, mc, saturationGained, flashAlpha);
            }
        }
    }

    public static void drawSaturationOverlay(float saturationGained, float saturationLevel, Minecraft mc, GuiGraphics guiGraphics, int right, int top, float alpha) {
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        float modifiedSaturation = Math.max(0.0f, Math.min(saturationLevel + saturationGained, 20.0f));
        int startSaturationBar = 0;
        int endSaturationBar = (int)Math.ceil(modifiedSaturation / 2.0f);
        if (saturationGained != 0.0f) {
            startSaturationBar = (int)Math.max(saturationLevel / 2.0f, 0.0f);
        }
        int iconSize = 9;
        for (int i = startSaturationBar; i < endSaturationBar; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 0;
            int u = 0;
            float effectiveSaturationOfBar = modifiedSaturation / 2.0f - (float)i;
            if (effectiveSaturationOfBar >= 1.0f) {
                u = 3 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.5) {
                u = 2 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.25) {
                u = 1 * iconSize;
            }
            guiGraphics.blit(TextureHelper.MOD_ICONS, x, y, u, v, iconSize, iconSize);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawHungerOverlay(int hungerRestored, int foodLevel, Minecraft mc, GuiGraphics guiGraphics, int right, int top, float alpha, boolean useRottenTextures) {
        if (hungerRestored <= 0) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        int modifiedFood = Math.max(0, Math.min(20, foodLevel + hungerRestored));
        int startFoodBars = Math.max(0, foodLevel / 2);
        int endFoodBars = (int)Math.ceil((float)modifiedFood / 2.0f);
        int iconStartOffset = 16;
        int iconSize = 9;
        for (int i = startFoodBars; i < endFoodBars; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            ResourceLocation backgroundSprite = TextureHelper.getFoodTexture(useRottenTextures, TextureHelper.FoodType.EMPTY);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.25f));
            guiGraphics.blitSprite(backgroundSprite, x, y, iconSize, iconSize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            boolean isHalf = i * 2 + 1 == modifiedFood;
            ResourceLocation iconSprite = TextureHelper.getFoodTexture(useRottenTextures, isHalf ? TextureHelper.FoodType.HALF : TextureHelper.FoodType.FULL);
            guiGraphics.blitSprite(iconSprite, x, y, iconSize, iconSize);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawHealthOverlay(float health, float modifiedHealth, Minecraft mc, GuiGraphics guiGraphics, int right, int top, float alpha) {
        if (modifiedHealth <= health) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        int fixedModifiedHealth = (int)Math.ceil(modifiedHealth);
        boolean isHardcore = mc.player.level() != null && mc.player.level().getLevelData().isHardcore();
        int startHealthBars = (int)Math.max(0.0, Math.ceil(health) / 2.0);
        int endHealthBars = (int)Math.max(0.0, Math.ceil(modifiedHealth / 2.0f));
        int iconStartOffset = 16;
        int iconSize = 9;
        for (int i = startHealthBars; i < endHealthBars; ++i) {
            IntPoint offset = healthBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            ResourceLocation backgroundSprite = TextureHelper.getHeartTexture(isHardcore, TextureHelper.HeartType.CONTAINER);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.25f));
            guiGraphics.blitSprite(backgroundSprite, x, y, iconSize, iconSize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            boolean isHalf = i * 2 + 1 == fixedModifiedHealth;
            ResourceLocation iconSprite = TextureHelper.getHeartTexture(isHardcore, isHalf ? TextureHelper.HeartType.HALF : TextureHelper.HeartType.FULL);
            guiGraphics.blitSprite(iconSprite, x, y, iconSize, iconSize);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawExhaustionOverlay(float exhaustion, Minecraft mc, GuiGraphics guiGraphics, int right, int top, float alpha) {
        float maxExhaustion = HungerHelper.getMaxExhaustion((Player)mc.player);
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        int height = 9;
        HUDOverlayHandler.enableAlpha(0.75f);
        guiGraphics.blit(TextureHelper.MOD_ICONS, right - width, top, 81 - width, 18, width, height);
        HUDOverlayHandler.disableAlpha(0.75f);
    }

    public static void enableAlpha(float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public static void disableAlpha(float alpha) {
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if ((unclampedFlashAlpha += (float)alphaDir * 0.125f) >= 1.5f) {
            alphaDir = (byte)-1;
        } else if (unclampedFlashAlpha <= -0.5f) {
            alphaDir = 1;
        }
        flashAlpha = Math.max(0.0f, Math.min(1.0f, unclampedFlashAlpha)) * Math.max(0.0f, Math.min(1.0f, ((Double)ModConfig.MAX_HUD_OVERLAY_FLASH_ALPHA.get()).floatValue()));
    }

    public static void resetFlash() {
        flashAlpha = 0.0f;
        unclampedFlashAlpha = 0.0f;
        alphaDir = 1;
    }

    private static void drawSaturationOverlay(HUDOverlayEvent.Saturation event, Minecraft mc, float saturationGained, float alpha) {
        HUDOverlayHandler.drawSaturationOverlay(saturationGained, event.saturationLevel, mc, event.guiGraphics, event.x, event.y, alpha);
    }

    private static void drawHungerOverlay(HUDOverlayEvent.HungerRestored event, Minecraft mc, int hunger, float alpha, boolean useRottenTextures) {
        HUDOverlayHandler.drawHungerOverlay(hunger, event.currentFoodLevel, mc, event.guiGraphics, event.x, event.y, alpha, useRottenTextures);
    }

    private static void drawHealthOverlay(HUDOverlayEvent.HealthRestored event, Minecraft mc, float alpha) {
        HUDOverlayHandler.drawHealthOverlay(mc.player.getHealth(), event.modifiedHealth, mc, event.guiGraphics, event.x, event.y, alpha);
    }

    private static void drawExhaustionOverlay(HUDOverlayEvent.Exhaustion event, Minecraft mc, float alpha) {
        HUDOverlayHandler.drawExhaustionOverlay(event.exhaustion, mc, event.guiGraphics, event.x, event.y, alpha);
    }

    private static boolean shouldRenderAnyOverlays() {
        return (Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY.get() != false || (Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get() != false || (Boolean)ModConfig.SHOW_FOOD_HEALTH_HUD_OVERLAY.get() != false;
    }

    private static boolean shouldShowEstimatedHealth(ItemStack hoveredStack, FoodValues modifiedFoodValues) {
        if (!((Boolean)ModConfig.SHOW_FOOD_HEALTH_HUD_OVERLAY.get()).booleanValue()) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        FoodData stats = player.getFoodData();
        if (player.level().getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        if (stats.getFoodLevel() >= 18) {
            return false;
        }
        if (player.hasEffect(MobEffects.POISON)) {
            return false;
        }
        if (player.hasEffect(MobEffects.WITHER)) {
            return false;
        }
        return !player.hasEffect(MobEffects.REGENERATION);
    }

    private static void generateHealthBarOffsets(int top, int left, int right, int ticks, Player player) {
        random.setSeed((long)ticks * 312871L);
        int preferHealthBars = 10;
        float maxHealth = player.getMaxHealth();
        float absorptionHealth = (float)Math.ceil(player.getAbsorptionAmount());
        int healthBars = (int)Math.ceil((maxHealth + absorptionHealth) / 2.0f);
        if (healthBars < 0 || healthBars > 1000) {
            healthBarOffsets.setSize(0);
            return;
        }
        int healthRows = (int)Math.ceil((float)healthBars / 10.0f);
        int healthRowHeight = Math.max(10 - (healthRows - 2), 3);
        boolean shouldAnimatedHealth = false;
        if (((Boolean)ModConfig.SHOW_VANILLA_ANIMATION_OVERLAY.get()).booleanValue()) {
            boolean bl = shouldAnimatedHealth = Math.ceil(player.getHealth()) <= 4.0;
        }
        if (healthBarOffsets.size() != healthBars) {
            healthBarOffsets.setSize(healthBars);
        }
        for (int i = healthBars - 1; i >= 0; --i) {
            IntPoint point;
            int row = (int)Math.ceil((float)(i + 1) / 10.0f) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * healthRowHeight;
            if (shouldAnimatedHealth) {
                y += random.nextInt(2);
            }
            if ((point = healthBarOffsets.get(i)) == null) {
                point = new IntPoint();
                healthBarOffsets.set(i, point);
            }
            point.x = x - left;
            point.y = y - top;
        }
    }

    private static void generateHungerBarOffsets(int top, int left, int right, int ticks, Player player) {
        int preferFoodBars = 10;
        boolean shouldAnimatedFood = false;
        if (((Boolean)ModConfig.SHOW_VANILLA_ANIMATION_OVERLAY.get()).booleanValue()) {
            FoodData stats = player.getFoodData();
            float saturationLevel = stats.getSaturationLevel();
            int foodLevel = stats.getFoodLevel();
            boolean bl = shouldAnimatedFood = saturationLevel <= 0.0f && ticks % (foodLevel * 3 + 1) == 0;
        }
        if (foodBarOffsets.size() != 10) {
            foodBarOffsets.setSize(10);
        }
        for (int i = 0; i < 10; ++i) {
            IntPoint point;
            int x = right - i * 8 - 9;
            int y = top;
            if (shouldAnimatedFood) {
                y += random.nextInt(3) - 1;
            }
            if ((point = foodBarOffsets.get(i)) == null) {
                point = new IntPoint();
                foodBarOffsets.set(i, point);
            }
            point.x = x - right;
            point.y = y - top;
        }
    }

    static {
        healthBarOffsets = new Vector();
        foodBarOffsets = new Vector();
        random = new Random();
        FOOD_LEVEL_ELEMENT = new ResourceLocation("minecraft", "food_level");
        PLAYER_HEALTH_ELEMENT = new ResourceLocation("minecraft", "player_health");
    }

    static enum RenderOverlayType {
        HEALTH,
        FOOD;

    }
}

