/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import com.mojang.datafixers.util.Pair;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import squeek.appleskin.api.food.FoodValues;

public class FoodHelper {
    public static float REGEN_EXHAUSTION_INCREMENT = 6.0f;
    public static float MAX_EXHAUSTION = 4.0f;

    public static boolean isFood(ItemStack itemStack, Player player) {
        return itemStack.getItem().getFoodProperties(itemStack, (LivingEntity)player) != null;
    }

    public static boolean canConsume(ItemStack itemStack, Player player) {
        if (!FoodHelper.isFood(itemStack, player)) {
            return false;
        }
        FoodProperties itemFood = itemStack.getItem().getFoodProperties(itemStack, (LivingEntity)player);
        if (itemFood == null) {
            return false;
        }
        return player.canEat(itemFood.canAlwaysEat());
    }

    public static FoodValues getDefaultFoodValues(ItemStack itemStack, Player player) {
        FoodProperties itemFood = itemStack.getItem().getFoodProperties(itemStack, (LivingEntity)player);
        int hunger = itemFood != null ? itemFood.getNutrition() : 0;
        float saturationModifier = itemFood != null ? itemFood.getSaturationModifier() : 0.0f;
        return new FoodValues(hunger, saturationModifier);
    }

    public static FoodValues getModifiedFoodValues(ItemStack itemStack, Player player) {
        return FoodHelper.getDefaultFoodValues(itemStack, player);
    }

    public static boolean isRotten(ItemStack itemStack, Player player) {
        if (!FoodHelper.isFood(itemStack, player)) {
            return false;
        }
        for (Pair effect : itemStack.getItem().getFoodProperties(itemStack, (LivingEntity)player).getEffects()) {
            if (effect.getFirst() == null || ((MobEffectInstance)effect.getFirst()).getEffect() == null || ((MobEffectInstance)effect.getFirst()).getEffect().getCategory() != MobEffectCategory.HARMFUL) continue;
            return true;
        }
        return false;
    }

    public static float getEstimatedHealthIncrement(ItemStack itemStack, FoodValues modifiedFoodValues, Player player) {
        if (!FoodHelper.isFood(itemStack, player)) {
            return 0.0f;
        }
        if (!player.isHurt()) {
            return 0.0f;
        }
        FoodData stats = player.getFoodData();
        Level world = player.getCommandSenderWorld();
        int foodLevel = Math.min(stats.getFoodLevel() + modifiedFoodValues.hunger, 20);
        float healthIncrement = 0.0f;
        if ((float)foodLevel >= 18.0f && world != null && world.getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) {
            float saturationLevel = Math.min(stats.getSaturationLevel() + modifiedFoodValues.getSaturationIncrement(), (float)foodLevel);
            float exhaustionLevel = stats.getExhaustionLevel();
            healthIncrement = FoodHelper.getEstimatedHealthIncrement(foodLevel, saturationLevel, exhaustionLevel);
        }
        for (Pair effect : itemStack.getItem().getFoodProperties(itemStack, (LivingEntity)player).getEffects()) {
            MobEffectInstance effectInstance = (MobEffectInstance)effect.getFirst();
            if (effectInstance == null || effectInstance.getEffect() != MobEffects.REGENERATION) continue;
            int amplifier = effectInstance.getAmplifier();
            int duration = effectInstance.getDuration();
            healthIncrement += (float)Math.floor(duration / Math.max(50 >> amplifier, 1));
            break;
        }
        return healthIncrement;
    }

    public static float getEstimatedHealthIncrement(int foodLevel, float saturationLevel, float exhaustionLevel) {
        float health = 0.0f;
        if (!Float.isFinite(exhaustionLevel) || !Float.isFinite(saturationLevel)) {
            return 0.0f;
        }
        while (foodLevel >= 18) {
            while (exhaustionLevel > MAX_EXHAUSTION) {
                exhaustionLevel -= MAX_EXHAUSTION;
                if (saturationLevel > 0.0f) {
                    saturationLevel = Math.max(saturationLevel - 1.0f, 0.0f);
                    continue;
                }
                --foodLevel;
            }
            if (foodLevel >= 20 && Float.compare(saturationLevel, Float.MIN_NORMAL) > 0) {
                float limitedSaturationLevel = Math.min(saturationLevel, REGEN_EXHAUSTION_INCREMENT);
                float exhaustionUntilAboveMax = Math.nextUp(MAX_EXHAUSTION) - exhaustionLevel;
                int numIterationsUntilAboveMax = Math.max(1, (int)Math.ceil(exhaustionUntilAboveMax / limitedSaturationLevel));
                health += limitedSaturationLevel / REGEN_EXHAUSTION_INCREMENT * (float)numIterationsUntilAboveMax;
                exhaustionLevel += limitedSaturationLevel * (float)numIterationsUntilAboveMax;
                continue;
            }
            if (foodLevel < 18) continue;
            health += 1.0f;
            exhaustionLevel += REGEN_EXHAUSTION_INCREMENT;
        }
        return health;
    }
}

