/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import net.minecraft.resources.ResourceLocation;

public class TextureHelper {
    public static final ResourceLocation MOD_ICONS = new ResourceLocation("appleskin", "textures/icons.png");
    public static final ResourceLocation HUNGER_OUTLINE_SPRITE = new ResourceLocation("appleskin", "tooltip_hunger_outline");
    public static final ResourceLocation FOOD_EMPTY_HUNGER_TEXTURE = new ResourceLocation("hud/food_empty_hunger");
    public static final ResourceLocation FOOD_HALF_HUNGER_TEXTURE = new ResourceLocation("hud/food_half_hunger");
    public static final ResourceLocation FOOD_FULL_HUNGER_TEXTURE = new ResourceLocation("hud/food_full_hunger");
    public static final ResourceLocation FOOD_EMPTY_TEXTURE = new ResourceLocation("hud/food_empty");
    public static final ResourceLocation FOOD_HALF_TEXTURE = new ResourceLocation("hud/food_half");
    public static final ResourceLocation FOOD_FULL_TEXTURE = new ResourceLocation("hud/food_full");
    public static final ResourceLocation HEART_CONTAINER = new ResourceLocation("hud/heart/container");
    public static final ResourceLocation HEART_HARDCORE_CONTAINER = new ResourceLocation("hud/heart/container_hardcore");
    public static final ResourceLocation HEART_FULL = new ResourceLocation("hud/heart/full");
    public static final ResourceLocation HEART_HARDCORE_FULL = new ResourceLocation("hud/heart/hardcore_full");
    public static final ResourceLocation HEART_HALF = new ResourceLocation("hud/heart/half");
    public static final ResourceLocation HEART_HARDCORE_HALF = new ResourceLocation("hud/heart/hardcore_half");

    public static ResourceLocation getFoodTexture(boolean isRotten, FoodType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FoodType.EMPTY -> {
                if (isRotten) {
                    yield FOOD_EMPTY_HUNGER_TEXTURE;
                }
                yield FOOD_EMPTY_TEXTURE;
            }
            case FoodType.HALF -> {
                if (isRotten) {
                    yield FOOD_HALF_HUNGER_TEXTURE;
                }
                yield FOOD_HALF_TEXTURE;
            }
            case FoodType.FULL -> isRotten ? FOOD_FULL_HUNGER_TEXTURE : FOOD_FULL_TEXTURE;
        };
    }

    public static ResourceLocation getHeartTexture(boolean hardcore, HeartType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case HeartType.CONTAINER -> {
                if (hardcore) {
                    yield HEART_HARDCORE_CONTAINER;
                }
                yield HEART_CONTAINER;
            }
            case HeartType.FULL -> {
                if (hardcore) {
                    yield HEART_HARDCORE_FULL;
                }
                yield HEART_FULL;
            }
            case HeartType.HALF -> hardcore ? HEART_HARDCORE_HALF : HEART_HALF;
        };
    }

    public static enum FoodType {
        EMPTY,
        HALF,
        FULL;

    }

    public static enum HeartType {
        CONTAINER,
        FULL,
        HALF;

    }
}

