/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record MessageSaturationSync(float saturationLevel) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("appleskin", "saturation");

    public MessageSaturationSync(FriendlyByteBuf buffer) {
        this(buffer.readFloat());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.saturationLevel());
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(MessageSaturationSync message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> player.getFoodData().setSaturation(message.saturationLevel())));
    }
}

