/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class FusionMixinPlugin
implements IMixinConfigPlugin {
    private boolean isEmbeddiumLoaded;

    public void onLoad(String mixinPackage) {
        this.isEmbeddiumLoaded = FusionMixinPlugin.isClassAvailable("org.embeddedt.embeddium.api.eventbus.EmbeddiumEvent");
    }

    private static boolean isClassAvailable(String className) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(className);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        if (this.isEmbeddiumLoaded) {
            mixins.add("embeddium.BlockRendererMixinEmbeddium");
        }
        return mixins;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

