/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.extensions.PackExtension;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import com.supermartijn642.fusion.resources.FusionPackMetadata;
import com.supermartijn642.fusion.resources.FusionPackMetadataSection;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Pack.class})
public class PackMixin
implements PackExtension {
    @Unique
    private FusionPackMetadata metadata;

    @Override
    @Nullable
    public FusionPackMetadata getFusionMetadata() {
        return this.metadata;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(String identifier, boolean required, Pack.ResourcesSupplier resourcesSupplier, Component title, Pack.Info info, Pack.Position position, boolean fixedPosition, PackSource packSource, CallbackInfo ci) {
        try (PackResources resources = resourcesSupplier.openPrimary(identifier);){
            this.metadata = (FusionPackMetadata)resources.getMetadataSection((MetadataSectionSerializer)FusionPackMetadataSection.INSTANCE);
        }
        catch (Exception e) {
            FusionClient.LOGGER.error("Encountered an exception whilst reading fusion metadata for pack '" + identifier + "':", (Throwable)e);
        }
    }

    @Inject(method={"open"}, at={@At(value="RETURN")})
    private void open(CallbackInfoReturnable<PackResources> ci) {
        PackResources resources = (PackResources)ci.getReturnValue();
        if (this.metadata != null && this.metadata.hasOverridesFolder() && resources instanceof PackResourcesExtension) {
            ((PackResourcesExtension)resources).setFusionOverridesFolder(this.metadata.getOverridesFolder());
        }
    }
}

