/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting.predicates;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MatchBlockInFrontConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<MatchBlockInFrontConnectionPredicate> SERIALIZER = new Serializer<MatchBlockInFrontConnectionPredicate>(){

        @Override
        public MatchBlockInFrontConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
                throw new JsonParseException("Match block predicate must have string property 'block'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
                throw new JsonParseException("Property 'block' must be a valid identifier!");
            }
            ResourceLocation identifier = new ResourceLocation(json.get("block").getAsString());
            if (!BuiltInRegistries.BLOCK.containsKey(identifier)) {
                throw new JsonParseException("Unknown block '" + identifier + "'!");
            }
            Block block = (Block)BuiltInRegistries.BLOCK.get(identifier);
            return new MatchBlockInFrontConnectionPredicate(block);
        }

        @Override
        public JsonObject serialize(MatchBlockInFrontConnectionPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("block", BuiltInRegistries.BLOCK.getKey((Object)value.block).toString());
            return json;
        }
    };
    private final Block block;

    public MatchBlockInFrontConnectionPredicate(Block block) {
        this.block = block;
    }

    @Override
    public boolean shouldConnect(Direction side, @Nullable BlockState ownState, BlockState otherState, BlockState blockInFront, ConnectionDirection direction) {
        return blockInFront.getBlock() == this.block;
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchBlockInFrontConnectionPredicate)) {
            return false;
        }
        MatchBlockInFrontConnectionPredicate that = (MatchBlockInFrontConnectionPredicate)o;
        return this.block.equals(that.block);
    }

    public int hashCode() {
        return this.block.hashCode();
    }
}

