/*
 * Decompiled with CFR 0.152.
 */
package fuzs.horseexpert.client.gui.screens.inventory.tooltip;

import fuzs.horseexpert.world.inventory.tooltip.HorseAttributeTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public record ClientHorseAttributeTooltip(@Nullable Item item, @Nullable MobEffect icon, Component line1, @Nullable Component line2) implements ClientTooltipComponent
{
    private static final int TEXT_INDENT = 4;
    private static final int ICON_SIZE = 20;
    private static final int FIRST_LINE_HEIGHT = 12;

    public ClientHorseAttributeTooltip(HorseAttributeTooltip tooltip) {
        this(tooltip.item(), tooltip.icon(), tooltip.line1(), tooltip.line2());
    }

    public int getWidth(Font font) {
        return Math.max(font.width((FormattedText)this.line1), this.line2 != null ? font.width((FormattedText)this.line2) : 0) + 8 + 20;
    }

    public int getHeight() {
        return 8;
    }

    public void renderText(Font font, int posX, int posY, Matrix4f matrix4f, MultiBufferSource.BufferSource multiBufferSource) {
        int width1 = font.width((FormattedText)this.line1);
        int width2 = this.line2 != null ? font.width((FormattedText)this.line2) : 0;
        int startX2 = 4;
        int startX1 = 4;
        if (width2 > width1) {
            startX1 += (width2 - width1) / 2;
        } else {
            startX2 += (width1 - width2) / 2;
        }
        if (this.line2 == null) {
            posY += 5;
        }
        font.drawInBatch(this.line1, (float)(posX + 20 + startX1), (float)(posY - 12), -1, true, matrix4f, (MultiBufferSource)multiBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        if (this.line2 != null) {
            font.drawInBatch(this.line2, (float)(posX + 20 + startX2), (float)(posY + 10 - 12), -1, true, matrix4f, (MultiBufferSource)multiBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public void renderImage(Font font, int posX, int posY, GuiGraphics guiGraphics) {
        if (this.item != null) {
            guiGraphics.renderItem(new ItemStack((ItemLike)this.item), posX + 2, posY + 1 - 12);
        }
        if (this.icon != null) {
            Minecraft minecraft = Minecraft.getInstance();
            TextureAtlasSprite atlasSprite = minecraft.getMobEffectTextures().get(this.icon);
            guiGraphics.blit(posX + 1, posY - 12, 0, 18, 18, atlasSprite);
        }
    }
}

