/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.ArcRecyclingChecker;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IECommonConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipes;
import blusunrize.immersiveengineering.common.items.DrillheadItem;
import blusunrize.immersiveengineering.common.items.HammerItem;
import blusunrize.immersiveengineering.common.items.JerrycanItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.ScrewdriverItem;
import blusunrize.immersiveengineering.common.items.WirecutterItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.MessageBirthdayParty;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import blusunrize.immersiveengineering.common.network.MessageContainerData;
import blusunrize.immersiveengineering.common.network.MessageContainerUpdate;
import blusunrize.immersiveengineering.common.network.MessageMagnetEquip;
import blusunrize.immersiveengineering.common.network.MessageMaintenanceKit;
import blusunrize.immersiveengineering.common.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.network.MessageMultiblockSync;
import blusunrize.immersiveengineering.common.network.MessageNoSpamChat;
import blusunrize.immersiveengineering.common.network.MessageObstructedConnection;
import blusunrize.immersiveengineering.common.network.MessageOpenManual;
import blusunrize.immersiveengineering.common.network.MessagePowerpackAntenna;
import blusunrize.immersiveengineering.common.network.MessageRedstoneLevel;
import blusunrize.immersiveengineering.common.network.MessageRequestEnergyUpdate;
import blusunrize.immersiveengineering.common.network.MessageRequestRedstoneUpdate;
import blusunrize.immersiveengineering.common.network.MessageRevolverRotate;
import blusunrize.immersiveengineering.common.network.MessageScrollwheelItem;
import blusunrize.immersiveengineering.common.network.MessageSetGhostSlots;
import blusunrize.immersiveengineering.common.network.MessageShaderManual;
import blusunrize.immersiveengineering.common.network.MessageSkyhookSync;
import blusunrize.immersiveengineering.common.network.MessageSpeedloaderSync;
import blusunrize.immersiveengineering.common.network.MessageStoredEnergy;
import blusunrize.immersiveengineering.common.network.MessageWireSync;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IEIMCHandler;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.commands.CommandHandler;
import blusunrize.immersiveengineering.common.util.compat.IECompatModules;
import blusunrize.immersiveengineering.common.world.IEWorldGen;
import blusunrize.immersiveengineering.common.world.Villages;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonStreamParser;
import com.mojang.brigadier.CommandDispatcher;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.apache.logging.log4j.LogManager;

@Mod(value="immersiveengineering")
public class ImmersiveEngineering {
    public static Dist DIST = Dist.DEDICATED_SERVER;
    public static final String MODID = "immersiveengineering";
    public static final String MODNAME = "Immersive Engineering";
    public static final String VERSION = IEApi.getCurrentVersion();
    public static final CommonProxy proxy = (CommonProxy)Util.make(() -> {
        if (FMLLoader.getDist().isClient()) {
            return new ClientProxy();
        }
        return new CommonProxy();
    });

    public ImmersiveEngineering(Dist dist, IEventBus modBus) {
        DIST = dist;
        IELogger.logger = LogManager.getLogger((String)MODID);
        modBus.addListener(this::setup);
        modBus.addListener(this::setupNetwork);
        modBus.addListener(this::enqueueIMCs);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::serverStarted);
        RecipeSerializers.RECIPE_SERIALIZERS.register(modBus);
        Villages.Registers.POINTS_OF_INTEREST.register(modBus);
        Villages.Registers.PROFESSIONS.register(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)IECommonConfig.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)IEClientConfig.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)IEServerConfig.CONFIG_SPEC);
        IEContent.modConstruction(modBus);
        if (dist.isClient()) {
            ClientProxy.modConstruction();
        }
        IEWorldGen.init(modBus);
        IECompatModules.onModConstruction(modBus);
    }

    public void setup(FMLCommonSetupEvent event) {
        IEApi.prefixToIngotMap.put("ingots", new Integer[]{1, 1});
        IEApi.prefixToIngotMap.put("nuggets", new Integer[]{1, 9});
        IEApi.prefixToIngotMap.put("storage_blocks", new Integer[]{9, 1});
        IEApi.prefixToIngotMap.put("plates", new Integer[]{1, 1});
        IEApi.prefixToIngotMap.put("wires", new Integer[]{1, 2});
        IEApi.prefixToIngotMap.put("gears", new Integer[]{4, 1});
        IEApi.prefixToIngotMap.put("rods", new Integer[]{1, 2});
        IEApi.prefixToIngotMap.put("fences", new Integer[]{5, 3});
        IEApi.prefixToIngotMap.put("cut_blocks", new Integer[]{9, 4});
        IEApi.prefixToIngotMap.put("cut_stairs", new Integer[]{9, 4});
        IEApi.prefixToIngotMap.put("cut_slabs", new Integer[]{9, 8});
        ArcRecyclingChecker.allowRecipeTypeForRecycling(RecipeType.CRAFTING);
        ArcRecyclingChecker.allowRecipeTypeForRecycling(IERecipeTypes.METAL_PRESS.get());
        ArcRecyclingChecker.allowSimpleItemForRecycling(stack -> stack instanceof DiggerItem || stack instanceof ShearsItem || stack instanceof SwordItem || stack instanceof ArmorItem || stack instanceof HorseArmorItem || stack instanceof BucketItem);
        ArcRecyclingChecker.allowSimpleItemForRecycling(stack -> stack instanceof HammerItem || stack instanceof WirecutterItem || stack instanceof ScrewdriverItem || stack instanceof DrillheadItem || stack instanceof JerrycanItem);
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> Stream.of(IEItems.Ingredients.GUNPART_BARREL, IEItems.Ingredients.GUNPART_DRUM, IEItems.Ingredients.GUNPART_HAMMER));
        ArcRecyclingChecker.allowItemTagForRecycling(IETags.plates);
        ArcRecyclingChecker.allowPrefixedTagForRecycling("rods/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("wires/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("gears/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("scaffoldings/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("scaffolding_stairs/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("scaffolding_slabs/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("fences/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("cut_blocks/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("cut_stairs/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("cut_slabs/");
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> Stream.of(IEBlocks.MetalDecoration.ALU_WALLMOUNT, IEBlocks.MetalDecoration.STEEL_WALLMOUNT, IEBlocks.MetalDecoration.STEEL_SLOPE, IEBlocks.MetalDecoration.ALU_SLOPE, IEBlocks.MetalDecoration.ALU_POST, IEBlocks.MetalDecoration.STEEL_POST, IEBlocks.MetalDecoration.STEEL_TRAPDOOR, IEBlocks.MetalDecoration.STEEL_DOOR, IEBlocks.MetalDecoration.ALU_CATWALK, IEBlocks.MetalDecoration.ALU_CATWALK_STAIRS, IEBlocks.MetalDecoration.STEEL_CATWALK, IEBlocks.MetalDecoration.STEEL_CATWALK_STAIRS));
        for (EnumMetals metal : EnumMetals.values()) {
            ArcRecyclingChecker.allowItemTagForRecycling(IETags.getItemTag(IETags.getTagsFor((EnumMetals)metal).sheetmetal));
        }
        ArcRecyclingChecker.allowItemTagForRecycling(IETags.getItemTag(IETags.sheetmetalSlabs));
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> Stream.of(IEBlocks.MetalDevices.RAZOR_WIRE, IEBlocks.MetalDevices.BARREL, IEBlocks.MetalDevices.FLUID_PIPE, IEBlocks.MetalDevices.PIPE_VALVE, IEBlocks.MetalDevices.FLUID_PLACER, IEBlocks.Connectors.CONNECTOR_STRUCTURAL));
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> IEBlocks.MetalDevices.CHUTES.values().stream());
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> Stream.of(Items.HEAVY_WEIGHTED_PRESSURE_PLATE, Items.LIGHT_WEIGHTED_PRESSURE_PLATE, Items.HOPPER, Items.IRON_TRAPDOOR, Items.IRON_DOOR, Items.IRON_BARS, Items.CAULDRON, Items.CHAIN, Items.MINECART, Items.ANVIL, Items.CHIPPED_ANVIL, Items.DAMAGED_ANVIL, Items.LIGHTNING_ROD));
        ArcRecyclingChecker.allowItemTagForRecycling(IETags.recyclingWhitelist);
        ArcRecyclingChecker.makeItemInvalidRecyclingOutput((tags, stack) -> stack.is(IETags.recyclingIgnoredComponents));
        new ThreadContributorSpecialsDownloader();
        IEContent.commonSetup((ParallelDispatchEvent)event);
        NeoForge.EVENT_BUS.register((Object)new EventHandler());
        IECompatModules.onCommonSetup();
        IEIMCHandler.init();
        IEIMCHandler.handleIMCMessages(InterModComms.getMessages((String)MODID));
        MetalPressPackingRecipes.init();
    }

    private void setupNetwork(RegisterPayloadHandlerEvent ev) {
        IPayloadRegistrar registrar = ev.registrar(MODID);
        this.registerMessage(registrar, MessageBlockEntitySync.ID, MessageBlockEntitySync::new);
        this.registerMessage(registrar, MessageContainerUpdate.ID, MessageContainerUpdate::new, PacketFlow.SERVERBOUND);
        this.registerMessage(registrar, MessageSpeedloaderSync.ID, MessageSpeedloaderSync::new, PacketFlow.CLIENTBOUND);
        this.registerMessage(registrar, MessageSkyhookSync.ID, MessageSkyhookSync::new, PacketFlow.CLIENTBOUND);
        this.registerMessage(registrar, MessageMinecartShaderSync.ID, MessageMinecartShaderSync::new);
        this.registerMessage(registrar, MessageRequestEnergyUpdate.ID, MessageRequestEnergyUpdate::new, PacketFlow.SERVERBOUND);
        this.registerMessage(registrar, MessageStoredEnergy.ID, MessageStoredEnergy::new, PacketFlow.CLIENTBOUND);
        this.registerMessage(registrar, MessageRequestRedstoneUpdate.ID, MessageRequestRedstoneUpdate::new, PacketFlow.SERVERBOUND);
        this.registerMessage(registrar, MessageRedstoneLevel.ID, MessageRedstoneLevel::new, PacketFlow.CLIENTBOUND);
        this.registerMessage(registrar, MessageShaderManual.ID, MessageShaderManual::new);
        this.registerMessage(registrar, MessageBirthdayParty.ID, MessageBirthdayParty::new, PacketFlow.CLIENTBOUND);
        this.registerMessage(registrar, MessageMagnetEquip.ID, MessageMagnetEquip::new, PacketFlow.SERVERBOUND);
        this.registerMessage(registrar, MessageScrollwheelItem.ID, MessageScrollwheelItem::new, PacketFlow.SERVERBOUND);
        this.registerMessage(registrar, MessageObstructedConnection.ID, MessageObstructedConnection::new, PacketFlow.CLIENTBOUND);
        this.registerMessage(registrar, MessageSetGhostSlots.ID, MessageSetGhostSlots::new, PacketFlow.SERVERBOUND);
        this.registerMessage(registrar, MessageWireSync.ID, MessageWireSync::new, PacketFlow.CLIENTBOUND);
        this.registerMessage(registrar, MessageMaintenanceKit.ID, MessageMaintenanceKit::new, PacketFlow.SERVERBOUND);
        this.registerMessage(registrar, MessageRevolverRotate.ID, MessageRevolverRotate::new, PacketFlow.SERVERBOUND);
        this.registerMessage(registrar, MessageMultiblockSync.ID, MessageMultiblockSync::new, PacketFlow.CLIENTBOUND);
        this.registerMessage(registrar, MessageContainerData.ID, MessageContainerData::new, PacketFlow.CLIENTBOUND);
        this.registerMessage(registrar, MessageNoSpamChat.ID, MessageNoSpamChat::new, PacketFlow.CLIENTBOUND);
        this.registerMessage(registrar, MessageOpenManual.ID, MessageOpenManual::new, PacketFlow.CLIENTBOUND);
        this.registerMessage(registrar, MessagePowerpackAntenna.ID, MessagePowerpackAntenna::new, PacketFlow.CLIENTBOUND);
    }

    private <T extends IMessage> void registerMessage(IPayloadRegistrar registrar, ResourceLocation id, FriendlyByteBuf.Reader<T> reader) {
        this.registerMessage(registrar, id, reader, Optional.empty());
    }

    private <T extends IMessage> void registerMessage(IPayloadRegistrar registrar, ResourceLocation id, FriendlyByteBuf.Reader<T> reader, PacketFlow direction) {
        this.registerMessage(registrar, id, reader, Optional.of(direction));
    }

    private <T extends IMessage> void registerMessage(IPayloadRegistrar registrar, ResourceLocation id, FriendlyByteBuf.Reader<T> reader, Optional<PacketFlow> direction) {
        if (direction.isPresent()) {
            registrar.play(id, reader, builder -> {
                if (direction.get() == PacketFlow.CLIENTBOUND) {
                    builder.client(IMessage::process);
                } else {
                    builder.server(IMessage::process);
                }
            });
        } else {
            registrar.play(id, reader, IMessage::process);
        }
    }

    public void enqueueIMCs(InterModEnqueueEvent event) {
        IECompatModules.doModulesIMCs();
        IEContent.clearLastFuture();
    }

    public void registerCommands(RegisterCommandsEvent event) {
        CommandHandler.registerServer((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void serverStarted(ServerStartedEvent event) {
        ServerLevel world = event.getServer().getLevel(Level.OVERWORLD);
        if (!world.isClientSide) {
            IESaveData worldData = (IESaveData)world.getDataStorage().computeIfAbsent(new SavedData.Factory(IESaveData::new, IESaveData::new), "ImmersiveEngineering-SaveData");
            IESaveData.setInstance(worldData);
        }
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static class ThreadContributorSpecialsDownloader
    extends Thread {
        public static ThreadContributorSpecialsDownloader activeThread;

        public ThreadContributorSpecialsDownloader() {
            this.setName("Immersive Engineering Contributors Thread");
            this.setDaemon(true);
            this.start();
            activeThread = this;
        }

        @Override
        public void run() {
            Gson gson = new Gson();
            try {
                IELogger.info("Attempting to download special revolvers from GitHub");
                URL url = new URL("https://raw.githubusercontent.com/BluSunrize/ImmersiveEngineering/gh-pages/contributorRevolvers.json");
                JsonStreamParser parser = new JsonStreamParser((Reader)new InputStreamReader(url.openStream()));
                while (parser.hasNext()) {
                    try {
                        JsonElement je = parser.next();
                        RevolverItem.SpecialRevolver revolver = (RevolverItem.SpecialRevolver)gson.fromJson(je, RevolverItem.SpecialRevolver.class);
                        if (revolver == null) continue;
                        if (revolver.uuid() != null) {
                            for (String uuid : revolver.uuid()) {
                                RevolverItem.specialRevolvers.put((Object)uuid, (Object)revolver);
                            }
                        }
                        RevolverItem.specialRevolversByTag.put(!revolver.tag().isEmpty() ? revolver.tag() : revolver.flavour(), revolver);
                    }
                    catch (Exception excepParse) {
                        IELogger.warn("Error on parsing a SpecialRevolver");
                    }
                }
            }
            catch (Exception e) {
                IELogger.logger.info("Could not load contributor+special revolver list.", (Throwable)e);
            }
        }
    }
}

