/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Random;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.util.JsonUtils;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.fluids.FluidStack;

public class ApiUtils {
    public static final Random RANDOM = new Random();
    public static final RandomSource RANDOM_SOURCE = RandomSource.createNewThreadLocalInstance();

    public static JsonElement jsonSerializeFluidStack(FluidStack fluidStack) {
        if (fluidStack == null) {
            return JsonNull.INSTANCE;
        }
        return (JsonElement)FluidStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)fluidStack).getOrThrow(false, s -> {});
    }

    public static FluidStack jsonDeserializeFluidStack(JsonObject jsonObject) {
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(GsonHelper.getAsString((JsonObject)jsonObject, (String)"fluid")));
        int amount = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"amount");
        FluidStack fluidStack = new FluidStack(fluid, amount);
        if (GsonHelper.isValidNode((JsonObject)jsonObject, (String)"tag")) {
            fluidStack.setTag(JsonUtils.readNBT((JsonObject)jsonObject, (String)"tag"));
        }
        return fluidStack;
    }

    public static Pair<ItemStack, Double> breakStackIntoPreciseIngots(RegistryAccess tags, ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[0]);
        String[] type = TagUtils.getMatchingPrefixAndRemaining(tags, stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return Pair.of((Object)IEApi.getPreferredTagStack(tags, TagUtils.createItemWrapper(IETags.getIngot(type[1]))), (Object)val);
        }
        return null;
    }

    public static double getDim(Vec3 vec, int dim) {
        return dim == 0 ? vec.x : (dim == 1 ? vec.y : vec.z);
    }

    public static void knockbackNoSource(LivingEntity entity, double strength, double xRatio, double zRatio) {
        entity.hasImpulse = true;
        Vec3 motionOld = entity.getDeltaMovement();
        Vec3 toAdd = new Vec3(xRatio, 0.0, zRatio).normalize().scale(strength);
        entity.setDeltaMovement(motionOld.x / 2.0 - toAdd.x, entity.onGround() ? Math.min(0.4, motionOld.y / 2.0 + strength) : motionOld.y, motionOld.z / 2.0 - toAdd.z);
    }

    public static void addFutureServerTask(Level world, Runnable task, boolean forceFuture) {
        LogicalSide side = world.isClientSide ? LogicalSide.CLIENT : LogicalSide.SERVER;
        BlockableEventLoop tmp = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(side);
        if (forceFuture) {
            int tick = world.isClientSide ? 0 : ((MinecraftServer)tmp).getTickCount();
            tmp.tell((Runnable)new TickTask(tick, task));
        } else {
            tmp.submitAsync(task);
        }
    }

    public static void addFutureServerTask(Level world, Runnable task) {
        ApiUtils.addFutureServerTask(world, task, false);
    }
}

