/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ComparableItemStack {
    public ItemStack stack;
    public boolean useNBT;

    public ComparableItemStack(ItemStack stack) {
        this(stack, false);
    }

    public ComparableItemStack(ItemStack stack, boolean copy) {
        if (stack == null) {
            throw new RuntimeException("You cannot instantiate a ComparableItemStack with null for an Item!");
        }
        this.stack = stack;
        if (copy) {
            this.copy();
        }
    }

    public static ComparableItemStack create(ItemStack stack, boolean copy) {
        return ComparableItemStack.create(stack, copy, stack.hasTag() && !stack.getOrCreateTag().isEmpty());
    }

    public static ComparableItemStack create(ItemStack stack, boolean copy, boolean useNbt) {
        ComparableItemStack comp = new ComparableItemStack(stack, copy);
        comp.setUseNBT(useNbt);
        return comp;
    }

    public void copy() {
        this.stack = this.stack.copy();
    }

    public ComparableItemStack setUseNBT(boolean useNBT) {
        this.useNBT = useNBT;
        return this;
    }

    public String toString() {
        return "ComparableStack: {" + this.stack.toString() + "}; checkNBT: " + this.useNBT;
    }

    public int hashCode() {
        int hash = this.stack.getItem().hashCode();
        if (this.useNBT && this.stack.hasTag()) {
            hash += this.stack.getOrCreateTag().hashCode() * 31;
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComparableItemStack)) {
            return false;
        }
        ItemStack otherStack = ((ComparableItemStack)object).stack;
        if (!ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)otherStack)) {
            return false;
        }
        if (this.useNBT) {
            return Objects.equals(this.stack.getTag(), otherStack.getTag()) && this.stack.areAttachmentsCompatible(otherStack);
        }
        return true;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.put("stack", (Tag)this.stack.save(new CompoundTag()));
        nbt.putBoolean("useNBT", this.useNBT);
        return nbt;
    }

    public static ComparableItemStack readFromNBT(CompoundTag nbt) {
        ComparableItemStack comp = new ComparableItemStack(ItemStack.of((CompoundTag)nbt.getCompound("stack")), false);
        comp.useNBT = nbt.getBoolean("useNBT");
        return comp;
    }
}

