/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ArcFurnaceRecipe
extends MultiblockRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<ArcFurnaceRecipe>> SERIALIZER;
    public static final SetRestrictedField<MultiblockRecipe.RecipeMultiplier> MULTIPLIERS;
    public final IngredientWithSize input;
    public final List<IngredientWithSize> additives;
    public final TagOutputList output;
    public final List<StackWithChance> secondaryOutputs;
    @Nonnull
    public final TagOutput slag;
    public String specialRecipeType;
    public static List<String> specialRecipeTypes;
    public static final CachedRecipeList<ArcFurnaceRecipe> RECIPES;

    public ArcFurnaceRecipe(TagOutputList output, @Nonnull TagOutput slag, List<StackWithChance> secondaryOutputs, int time, int energy, IngredientWithSize input, List<IngredientWithSize> additives) {
        super(output.getLazyList().get(0), IERecipeTypes.ARC_FURNACE, time, energy, MULTIPLIERS);
        this.output = output;
        this.secondaryOutputs = secondaryOutputs;
        this.input = input;
        this.slag = slag;
        this.additives = additives;
        ArrayList inputList = Lists.newArrayList((Object[])new IngredientWithSize[]{this.input});
        if (!this.additives.isEmpty()) {
            inputList.addAll(Lists.newArrayList(this.additives));
        }
        this.setInputListWithSizes(inputList);
        this.outputList = this.output;
    }

    protected IERecipeSerializer<ArcFurnaceRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    public NonNullList<ItemStack> getBaseOutputs() {
        return this.output.get();
    }

    public NonNullList<ItemStack> generateActualOutput(ItemStack input, NonNullList<ItemStack> additives, long seed) {
        Random random = new Random(seed);
        NonNullList<ItemStack> output = this.output.get();
        int remainingIndex = output.size();
        NonNullList actualOutput = NonNullList.withSize((int)(output.size() + this.secondaryOutputs.size()), (Object)ItemStack.EMPTY);
        for (int i = 0; i < output.size(); ++i) {
            actualOutput.set(i, (Object)((ItemStack)output.get(i)).copy());
        }
        for (StackWithChance secondary : this.secondaryOutputs) {
            if (secondary.chance() < random.nextFloat()) continue;
            ItemStack remaining = secondary.stack().get();
            for (ItemStack existing : actualOutput) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)remaining, (ItemStack)existing)) continue;
                existing.grow(remaining.getCount());
                remaining = ItemStack.EMPTY;
                break;
            }
            if (remaining.isEmpty()) continue;
            actualOutput.set(remainingIndex, (Object)remaining);
            ++remainingIndex;
        }
        return actualOutput;
    }

    public boolean matches(ItemStack input, NonNullList<ItemStack> additives) {
        if (this.input != null && this.input.test(input)) {
            int[] consumed = this.getConsumedAdditives(additives, false);
            return consumed != null;
        }
        return false;
    }

    public int[] getConsumedAdditives(NonNullList<ItemStack> additives, boolean consume) {
        int[] consumed = new int[additives.size()];
        for (IngredientWithSize add : this.additives) {
            if (add == null) continue;
            int addAmount = add.getCount();
            Iterator it = additives.iterator();
            int i = 0;
            while (it.hasNext()) {
                ItemStack query = (ItemStack)it.next();
                if (!query.isEmpty()) {
                    if (add.test(query)) {
                        if (query.getCount() > addAmount) {
                            query.shrink(addAmount);
                            consumed[i] = addAmount;
                            addAmount = 0;
                        } else {
                            addAmount -= query.getCount();
                            consumed[i] = query.getCount();
                            query.setCount(0);
                        }
                    }
                    if (addAmount <= 0) break;
                }
                ++i;
            }
            if (addAmount <= 0) continue;
            for (int j = 0; j < consumed.length; ++j) {
                ((ItemStack)additives.get(j)).grow(consumed[j]);
            }
            return null;
        }
        if (!consume) {
            for (int j = 0; j < consumed.length; ++j) {
                ((ItemStack)additives.get(j)).grow(consumed[j]);
            }
        }
        return consumed;
    }

    public boolean isValidInput(ItemStack stack) {
        return this.input != null && this.input.test(stack);
    }

    public boolean isValidAdditive(ItemStack stack) {
        for (IngredientWithSize add : this.additives) {
            if (add == null || !add.test(stack)) continue;
            return true;
        }
        return false;
    }

    public ArcFurnaceRecipe setSpecialRecipeType(String type) {
        this.specialRecipeType = type;
        if (!specialRecipeTypes.contains(type)) {
            specialRecipeTypes.add(type);
        }
        return this;
    }

    public static RecipeHolder<ArcFurnaceRecipe> findRecipe(Level level, ItemStack input, NonNullList<ItemStack> additives) {
        for (RecipeHolder<ArcFurnaceRecipe> recipe : RECIPES.getRecipes(level)) {
            if (!((ArcFurnaceRecipe)recipe.value()).matches(input, additives)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isValidRecipeInput(Level level, ItemStack stack) {
        for (RecipeHolder<ArcFurnaceRecipe> recipe : RECIPES.getRecipes(level)) {
            if (!((ArcFurnaceRecipe)recipe.value()).isValidInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidRecipeAdditive(Level level, ItemStack stack) {
        for (RecipeHolder<ArcFurnaceRecipe> recipe : RECIPES.getRecipes(level)) {
            if (recipe == null || !((ArcFurnaceRecipe)recipe.value()).isValidAdditive(stack)) continue;
            return true;
        }
        return false;
    }

    static {
        MULTIPLIERS = SetRestrictedField.common();
        specialRecipeTypes = new ArrayList<String>();
        RECIPES = new CachedRecipeList<ArcFurnaceRecipe>(IERecipeTypes.ARC_FURNACE);
    }
}

