/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ClocheFertilizer
extends IESerializableRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<ClocheFertilizer>> SERIALIZER;
    public static final CachedRecipeList<ClocheFertilizer> RECIPES;
    public final Ingredient input;
    public final float growthModifier;

    public ClocheFertilizer(Ingredient input, float growthModifier) {
        super(TagOutput.EMPTY, IERecipeTypes.FERTILIZER);
        this.input = input;
        this.growthModifier = growthModifier;
    }

    public float getGrowthModifier() {
        return this.growthModifier;
    }

    protected IERecipeSerializer<ClocheFertilizer> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack getResultItem(RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public static float getFertilizerGrowthModifier(Level level, ItemStack stack) {
        for (RecipeHolder<ClocheFertilizer> e : RECIPES.getRecipes(level)) {
            if (!((ClocheFertilizer)e.value()).input.test(stack)) continue;
            return ((ClocheFertilizer)e.value()).getGrowthModifier();
        }
        return 0.0f;
    }

    public static boolean isValidFertilizer(Level level, ItemStack stack) {
        return ClocheFertilizer.getFertilizerGrowthModifier(level, stack) > 0.0f;
    }

    static {
        RECIPES = new CachedRecipeList<ClocheFertilizer>(IERecipeTypes.FERTILIZER);
    }
}

