/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public interface ClocheRenderFunction {
    public static final BiMap<ResourceLocation, Codec<? extends ClocheRenderFunction>> RENDER_FUNCTION_FACTORIES = HashBiMap.create();
    public static final Codec<ClocheRenderFunction> CODEC = ResourceLocation.CODEC.dispatch(f -> (ResourceLocation)RENDER_FUNCTION_FACTORIES.inverse().get(f.codec()), arg_0 -> RENDER_FUNCTION_FACTORIES.get(arg_0));

    public float getScale(ItemStack var1, float var2);

    public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack var1, float var2);

    default public void injectQuads(ItemStack stack, float growth, Consumer<?> quadConsumer) {
    }

    public Codec<? extends ClocheRenderFunction> codec();

    public static void write(FriendlyByteBuf buffer, ClocheRenderFunction f) {
        buffer.writeJsonWithCodec(CODEC, (Object)f);
    }

    public static ClocheRenderFunction read(FriendlyByteBuf buffer) {
        return (ClocheRenderFunction)buffer.readJsonWithCodec(CODEC);
    }
}

