/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidTagInput
implements Predicate<FluidStack> {
    public static final Codec<FluidTagInput> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.mapEither((MapCodec)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("tag"), (MapCodec)ResourceLocation.CODEC.listOf().fieldOf("fluids")).forGetter(t -> t.fluidTag), (App)Codec.INT.fieldOf("amount").forGetter(t -> t.amount), (App)ExtraCodecs.strictOptionalField((Codec)CompoundTag.CODEC, (String)"nbt").forGetter(t -> Optional.ofNullable(t.nbtTag))).apply((Applicative)inst, (tag, amount, nbt) -> new FluidTagInput((Either<TagKey<Fluid>, List<ResourceLocation>>)tag, (int)amount, (CompoundTag)nbt.orElse(null))));
    protected final Either<TagKey<Fluid>, List<ResourceLocation>> fluidTag;
    protected final int amount;
    protected final CompoundTag nbtTag;

    private static <S> JsonObject toJson(Dynamic<S> in) {
        return ((JsonElement)in.getOps().convertTo((DynamicOps)JsonOps.INSTANCE, in.getValue())).getAsJsonObject();
    }

    public FluidTagInput(Either<TagKey<Fluid>, List<ResourceLocation>> matching, int amount, CompoundTag nbtTag) {
        this.fluidTag = matching;
        this.amount = amount;
        this.nbtTag = nbtTag;
    }

    public FluidTagInput(TagKey<Fluid> fluidTag, int amount, CompoundTag nbtTag) {
        this((Either<TagKey<Fluid>, List<ResourceLocation>>)Either.left(fluidTag), amount, nbtTag);
    }

    public FluidTagInput(ResourceLocation resourceLocation, int amount, CompoundTag nbtTag) {
        this((TagKey<Fluid>)TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)resourceLocation), amount, nbtTag);
    }

    public FluidTagInput(ResourceLocation resourceLocation, int amount) {
        this(resourceLocation, amount, null);
    }

    public FluidTagInput(TagKey<Fluid> tag, int amount) {
        this(tag, amount, null);
    }

    public static FluidTagInput deserialize(JsonElement input) {
        Preconditions.checkArgument((boolean)(input instanceof JsonObject), (Object)"FluidTagWithSize can only be deserialized from a JsonObject");
        JsonObject jsonObject = input.getAsJsonObject();
        ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.getAsString((JsonObject)jsonObject, (String)"tag"));
        if (!GsonHelper.isValidNode((JsonObject)jsonObject, (String)"nbt")) {
            return new FluidTagInput(resourceLocation, GsonHelper.getAsInt((JsonObject)jsonObject, (String)"amount"));
        }
        try {
            CompoundTag nbt = ItemUtils.parseNbtFromJson(jsonObject.get("nbt"));
            return new FluidTagInput(resourceLocation, GsonHelper.getAsInt((JsonObject)jsonObject, (String)"amount"), nbt);
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public FluidTagInput withAmount(int amount) {
        return new FluidTagInput(this.fluidTag, amount, this.nbtTag);
    }

    @Override
    public boolean test(@Nullable FluidStack fluidStack) {
        return this.testIgnoringAmount(fluidStack) && fluidStack.getAmount() >= this.amount;
    }

    public boolean testIgnoringAmount(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        if (!((Boolean)this.fluidTag.map(t -> fluidStack.getFluid().is(t), l -> l.contains(BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid())))).booleanValue()) {
            return false;
        }
        if (this.nbtTag != null) {
            return fluidStack.hasTag() && fluidStack.getTag().equals((Object)this.nbtTag);
        }
        return true;
    }

    @Nonnull
    public List<FluidStack> getMatchingFluidStacks() {
        return ((Stream)this.fluidTag.map(t -> TagUtils.elementStream(BuiltInRegistries.FLUID, t), l -> l.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).get(arg_0)))).map(fluid -> new FluidStack(fluid, this.amount, this.nbtTag)).collect(Collectors.toList());
    }

    @Nonnull
    public JsonElement serialize() {
        JsonObject jsonObject = new JsonObject();
        ResourceLocation name = ((TagKey)this.fluidTag.orThrow()).location();
        jsonObject.addProperty("tag", name.toString());
        jsonObject.addProperty("amount", (Number)this.amount);
        if (this.nbtTag != null) {
            jsonObject.addProperty("nbt", this.nbtTag.toString());
        }
        return jsonObject;
    }

    public int getAmount() {
        return this.amount;
    }

    public FluidStack getRandomizedExampleStack(int rand) {
        List<FluidStack> all = this.getMatchingFluidStacks();
        return all.get(rand / 20 % all.size());
    }

    public static FluidTagInput read(FriendlyByteBuf input) {
        int numMatching = input.readVarInt();
        ArrayList<ResourceLocation> matching = new ArrayList<ResourceLocation>(numMatching);
        for (int i = 0; i < numMatching; ++i) {
            matching.add(input.readResourceLocation());
        }
        int amount = input.readInt();
        CompoundTag nbt = input.readBoolean() ? input.readNbt() : null;
        return new FluidTagInput((Either<TagKey<Fluid>, List<ResourceLocation>>)Either.right(matching), amount, nbt);
    }

    public void write(FriendlyByteBuf out) {
        List matching = (List)this.fluidTag.map(f -> TagUtils.holderStream(BuiltInRegistries.FLUID, f).map(Holder::unwrapKey).map(Optional::orElseThrow).map(ResourceKey::location).collect(Collectors.toList()), l -> l);
        out.writeVarInt(matching.size());
        for (ResourceLocation rl : matching) {
            out.writeResourceLocation(rl);
        }
        out.writeInt(this.amount);
        out.writeBoolean(this.nbtTag != null);
        if (this.nbtTag != null) {
            out.writeNbt((Tag)this.nbtTag);
        }
    }

    public boolean extractFrom(IFluidHandler handler, IFluidHandler.FluidAction action) {
        for (int tank = 0; tank < handler.getTanks(); ++tank) {
            FluidStack toExtract;
            FluidStack extractedSim;
            FluidStack inTank = handler.getFluidInTank(tank);
            if (!this.testIgnoringAmount(inTank) || (extractedSim = handler.drain(toExtract = FluidUtils.copyFluidStackWithAmount(inTank, this.amount), IFluidHandler.FluidAction.SIMULATE)).getAmount() < this.amount) continue;
            if (action != IFluidHandler.FluidAction.SIMULATE) {
                handler.drain(toExtract, action);
            }
            return true;
        }
        return false;
    }
}

