/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class IERecipeSerializer<R extends Recipe<?>>
implements RecipeSerializer<R> {
    public static final Codec<List<StackWithChance>> CHANCE_LIST = IERecipeSerializer.makeChanceOutputCodec();

    public static MapCodec<TagOutput> optionalItemOutput(String name) {
        return TagOutput.CODEC.optionalFieldOf(name, (Object)TagOutput.EMPTY);
    }

    public static MapCodec<FluidStack> optionalFluidOutput(String name) {
        return FluidStack.CODEC.optionalFieldOf(name, (Object)FluidStack.EMPTY);
    }

    public abstract ItemStack getIcon();

    protected static TagOutput readLazyStack(FriendlyByteBuf buf) {
        return new TagOutput(buf.readItem());
    }

    protected static void writeLazyStack(FriendlyByteBuf buf, TagOutput stack) {
        buf.writeItem(stack.get());
    }

    protected static <T> MapCodec<Optional<List<T>>> maybeListOrSingle(Codec<T> singleCodec, String key) {
        return Codec.mapEither(IERecipeSerializer.listOrSingle(singleCodec, key), (MapCodec)Codec.EMPTY).xmap(e -> (Optional)e.map(Optional::of, $ -> Optional.empty()), o -> o.isPresent() ? Either.left((Object)((List)o.get())) : Either.right((Object)Unit.INSTANCE));
    }

    protected static <T> MapCodec<List<T>> listOrSingle(Codec<T> singleCodec, String key) {
        return IERecipeSerializer.listOrSingle(singleCodec, key, key);
    }

    protected static <T> MapCodec<List<T>> listOrSingle(Codec<T> singleCodec, String singleKey, String listKey) {
        return Codec.mapEither((MapCodec)singleCodec.fieldOf(singleKey), (MapCodec)singleCodec.listOf().fieldOf(listKey)).xmap(e -> (List)e.map(List::of, Function.identity()), l -> l.size() == 1 ? Either.left(l.get(0)) : Either.right((Object)l));
    }

    private static Codec<List<StackWithChance>> makeChanceOutputCodec() {
        final Codec baseCodec = StackWithChance.CODEC.listOf();
        Decoder<List<StackWithChance>> conditionalDecoder = new Decoder<List<StackWithChance>>(){

            public <T> DataResult<Pair<List<StackWithChance>, T>> decode(DynamicOps<T> ops, T input) {
                Codec contextCodec = ConditionalOps.retrieveContext().codec();
                return baseCodec.decode(ops, input).flatMap(listAndData -> contextCodec.decode(ops, ops.emptyMap()).map(ctxAndData -> {
                    ArrayList<StackWithChance> filtered = new ArrayList<StackWithChance>();
                    for (StackWithChance stack : (List)listAndData.getFirst()) {
                        boolean matches = true;
                        for (ICondition condition : stack.conditions()) {
                            matches &= condition.test((ICondition.IContext)ctxAndData.getFirst());
                        }
                        if (!matches) continue;
                        filtered.add(stack);
                    }
                    return Pair.of(filtered, (Object)ctxAndData.getSecond());
                }));
            }
        };
        return Codec.of((Encoder)baseCodec, (Decoder)conditionalDecoder);
    }
}

