/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public interface IMultiblockRecipe {
    public List<IngredientWithSize> getItemInputs();

    default public boolean shouldCheckItemAvailability() {
        return true;
    }

    public List<FluidTagInput> getFluidInputs();

    public NonNullList<ItemStack> getItemOutputs();

    default public NonNullList<ItemStack> getActualItemOutputs() {
        return this.getItemOutputs();
    }

    public List<FluidStack> getFluidOutputs();

    default public ItemStack getDisplayStack(ItemStack input) {
        for (IngredientWithSize ingr : this.getItemInputs()) {
            if (!ingr.test(input)) continue;
            if (ingr.hasNoMatchingItems()) {
                return input;
            }
            return ingr.getMatchingStacks()[0];
        }
        return ItemStack.EMPTY;
    }

    default public List<FluidStack> getActualFluidOutputs() {
        return this.getFluidOutputs();
    }

    public int getTotalProcessTime();

    public int getTotalProcessEnergy();

    public int getMultipleProcessTicks();
}

