/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.TagOutput;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.conditions.ICondition;

public record StackWithChance(TagOutput stack, float chance, List<ICondition> conditions) {
    public static final Codec<StackWithChance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TagOutput.CODEC.fieldOf("output").forGetter(StackWithChance::stack), (App)Codec.FLOAT.fieldOf("chance").forGetter(StackWithChance::chance), (App)ICondition.LIST_CODEC.fieldOf("conditions").forGetter(StackWithChance::conditions)).apply((Applicative)inst, StackWithChance::new));

    public StackWithChance {
        Preconditions.checkNotNull((Object)stack);
    }

    public StackWithChance(ItemStack stack, float chance) {
        this(new TagOutput(stack), chance, List.of());
    }

    public StackWithChance(TagOutput stack, float chance, ICondition ... conditions) {
        this(stack, chance, Arrays.asList(conditions));
    }

    public CompoundTag writeToNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.put("stack", (Tag)this.stack.get().save(new CompoundTag()));
        compoundNBT.putFloat("chance", this.chance);
        return compoundNBT;
    }

    public static StackWithChance readFromNBT(CompoundTag compoundNBT) {
        Preconditions.checkNotNull((Object)compoundNBT);
        Preconditions.checkArgument((boolean)compoundNBT.contains("chance"));
        Preconditions.checkArgument((boolean)compoundNBT.contains("stack"));
        ItemStack stack = ItemStack.of((CompoundTag)compoundNBT.getCompound("stack"));
        float chance = compoundNBT.getFloat("chance");
        return new StackWithChance(stack, chance);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeItem(this.stack.get());
        buffer.writeFloat(this.chance);
    }

    public static StackWithChance read(FriendlyByteBuf buffer) {
        return new StackWithChance(buffer.readItem(), buffer.readFloat());
    }

    public StackWithChance recalculate(double totalChance) {
        return new StackWithChance(this.stack, (float)((double)this.chance / totalChance), this.conditions);
    }
}

