/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class TagOutput {
    public static final Codec<TagOutput> CODEC = Codec.either(IngredientWithSize.CODEC, (Codec)ItemStack.CODEC).xmap(TagOutput::new, out -> out.rawData);
    public static final TagOutput EMPTY = new TagOutput(new IngredientWithSize(Ingredient.EMPTY));
    private final Either<IngredientWithSize, ItemStack> rawData;
    private ItemStack cachedStack;

    public TagOutput(Either<IngredientWithSize, ItemStack> type) {
        this.rawData = type;
    }

    public TagOutput(ItemLike type) {
        this(type, 1);
    }

    public TagOutput(ItemLike type, int count) {
        this(new IngredientWithSize(Ingredient.of((ItemLike[])new ItemLike[]{type}), count));
    }

    public TagOutput(IngredientWithSize type) {
        this((Either<IngredientWithSize, ItemStack>)Either.left((Object)type));
    }

    public TagOutput(ItemStack stack) {
        this((Either<IngredientWithSize, ItemStack>)Either.right((Object)stack));
    }

    public TagOutput(TagKey<Item> type, int count) {
        this(new IngredientWithSize(type, count));
    }

    public TagOutput(TagKey<Item> type) {
        this(type, 1);
    }

    public ItemStack get() {
        if (this.cachedStack == null) {
            this.cachedStack = (ItemStack)this.rawData.map(iws -> {
                if (iws.basePredicate.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                return IEApi.getPreferredStackbyMod(iws.getMatchingStacks());
            }, Function.identity());
        }
        return this.cachedStack;
    }
}

